/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.test;

import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.scada.chart.AsyncFunctionSeriesData;
import org.eclipse.scada.chart.DataEntry;
import org.eclipse.scada.chart.Realm;
import org.eclipse.scada.chart.SeriesData;
import org.eclipse.scada.chart.WritableSeries;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.ChartArea;
import org.eclipse.scada.chart.swt.DisplayRealm;
import org.eclipse.scada.chart.swt.controller.MouseDragZoomer;
import org.eclipse.scada.chart.swt.controller.MouseTransformer;
import org.eclipse.scada.chart.swt.controller.MouseWheelZoomer;
import org.eclipse.scada.chart.swt.render.LinearRenderer;
import org.eclipse.scada.chart.swt.render.QualityRenderer;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.scada.chart.swt.render.StepRenderer;
import org.eclipse.scada.chart.swt.render.XAxisDynamicRenderer;
import org.eclipse.scada.chart.swt.render.YAxisDynamicRenderer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Application
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Chart Test");
        shell.setSize(800, 600);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        shell.setLayout((Layout)layout);
        ChartArea chart = new ChartArea((Composite)shell, 0);
        chart.setLayoutData((Object)this.makeCenterData());
        chart.setBackground(Display.getCurrent().getSystemColor(1));
        XAxis x = new XAxis();
        x.setLabel("Time");
        YAxis y = new YAxis();
        y.setLabel("Value");
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
        DisplayRealm realm = new DisplayRealm(Display.getDefault());
        WritableSeries series1 = new WritableSeries((Realm)realm, x, y);
        WritableSeries series2 = new WritableSeries((Realm)realm, x, y);
        WritableSeries series3 = new WritableSeries((Realm)realm, x, y);
        AsyncFunctionSeriesData series4 = new AsyncFunctionSeriesData((Realm)realm, x, y, 1000){

            protected Double eval(long timestamp) {
                double v = Math.sin(Math.toRadians((double)timestamp / 100.0)) * 100.0;
                v += Math.sin(Math.toRadians(timestamp)) * 10.0;
                return v += Math.sin(Math.toRadians((double)timestamp / 10000.0)) * 100.0;
            }
        };
        LinearRenderer series1Renderer = new LinearRenderer(chart.getChartRenderer(), (SeriesData)series1);
        series1Renderer.setLineColor(resourceManager.createColor(new RGB(255, 0, 0)));
        chart.getChartRenderer().addRenderer((Renderer)series1Renderer);
        chart.getChartRenderer().addRenderer((Renderer)new LinearRenderer(chart.getChartRenderer(), (SeriesData)series4));
        chart.getChartRenderer().addRenderer((Renderer)new StepRenderer(chart.getChartRenderer(), (SeriesData)series3));
        chart.getChartRenderer().addRenderer((Renderer)new QualityRenderer(chart.getChartRenderer(), (SeriesData)series4));
        this.createSine(series1, -10, 10, 0.05, 100.0, 100);
        this.createSine(series2, -20, 20, 0.1, 50.0, 200);
        this.createLinear(series3, 40, 240, 80.0, 40);
        x.setMinMax(series1.getData().getMinTimestamp(), series1.getData().getMaxTimestamp());
        y.setMinMax(series1.getData().getMinValue(), series1.getData().getMaxValue());
        new MouseWheelZoomer(chart.getChartRenderer(), x, y);
        new MouseTransformer(chart.getChartRenderer(), x, y);
        new MouseDragZoomer(chart.getChartRenderer(), x, y);
        XAxisDynamicRenderer xAxisRender1 = new XAxisDynamicRenderer(chart.getChartRenderer());
        xAxisRender1.setAxis(x);
        chart.getChartRenderer().addRenderer((Renderer)xAxisRender1, -1);
        XAxisDynamicRenderer xAxisRender2 = new XAxisDynamicRenderer(chart.getChartRenderer());
        xAxisRender2.setAlign(128);
        xAxisRender2.setAxis(x);
        xAxisRender2.setFormat("%1$tc\n%1$tc");
        chart.getChartRenderer().addRenderer((Renderer)xAxisRender2, -1);
        YAxisDynamicRenderer yAxisRender1 = new YAxisDynamicRenderer(chart.getChartRenderer());
        yAxisRender1.setAlign(16384);
        yAxisRender1.setAxis(y);
        chart.getChartRenderer().addRenderer((Renderer)yAxisRender1, -1);
        YAxisDynamicRenderer yAxisRender2 = new YAxisDynamicRenderer(chart.getChartRenderer());
        yAxisRender2.setAlign(131072);
        yAxisRender2.setAxis(y);
        chart.getChartRenderer().addRenderer((Renderer)yAxisRender2, -1);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        return null;
    }

    private GridData makeCenterData() {
        GridData result = new GridData(4, 4, true, true);
        return result;
    }

    private void createSine(WritableSeries series, int startTimestampOffset, int endTimestampOffset, double frequency, double amplitude, int numberOfSamples) {
        long now = System.currentTimeMillis();
        long start = now + (long)(startTimestampOffset * 1000);
        long end = now + (long)(endTimestampOffset * 1000);
        long diff = end - start;
        double timeSlice = (double)diff / (double)numberOfSamples;
        double currentTime = start;
        while (currentTime < (double)end) {
            series.getData().add(new DataEntry((long)currentTime, Double.valueOf(Math.sin(Math.toRadians(currentTime) * frequency) * amplitude)));
            currentTime += timeSlice;
        }
    }

    private void createLinear(WritableSeries series, int startTimestampOffset, int endTimestampOffset, double ampltiude, int numberOfSamples) {
        long now = System.currentTimeMillis();
        long start = now + (long)(startTimestampOffset * 1000);
        long end = now + (long)(endTimestampOffset * 1000);
        long diff = end - start;
        double timeSlice = (double)diff / (double)numberOfSamples;
        double add = ampltiude / (double)numberOfSamples;
        double currentTime = start;
        double value = 0.0;
        int cnt = 0;
        while (currentTime < (double)end) {
            if (cnt % 10 == 0) {
                series.getData().add(new DataEntry((long)currentTime, null));
            } else {
                series.getData().add(new DataEntry((long)currentTime, Double.valueOf(value)));
            }
            value += add;
            currentTime += timeSlice;
            ++cnt;
        }
    }

    public void stop() {
    }
}

