/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.controller;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.ChartMouseListener;
import org.eclipse.scada.chart.swt.ChartMouseMoveListener;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.DisposeListener;
import org.eclipse.scada.chart.swt.controller.AbstractMouseHandler;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;

public class MouseTransformer
extends AbstractMouseHandler
implements ChartMouseListener,
ChartMouseMoveListener {
    private boolean active;
    private int startX;
    private int startY;
    private final ChartRenderer chartArea;

    public MouseTransformer(ChartRenderer chartArea, IObservableList xAxis, IObservableList yAxis) {
        super(xAxis, yAxis);
        this.chartArea = chartArea;
        chartArea.addDisposeListener(new DisposeListener(){

            @Override
            public void onDispose() {
                MouseTransformer.this.dispose();
            }
        });
        chartArea.addMouseListener(this);
        chartArea.addMouseMoveListener(this);
    }

    public void dispose() {
        this.chartArea.removeMouseListener(this);
        this.chartArea.removeMouseMoveListener(this);
    }

    @Override
    public void onMouseDoubleClick(ChartMouseListener.MouseState state) {
    }

    @Override
    public void onMouseDown(ChartMouseListener.MouseState e) {
        if (e.button != 1 || e.state != SWT.MOD1) {
            return;
        }
        Rectangle rect = this.chartArea.getClientAreaProxy().getClientRectangle();
        if (e.x < rect.x || e.x > rect.x + rect.width) {
            return;
        }
        if (e.y < rect.y || e.y > rect.y + rect.height) {
            return;
        }
        this.active = true;
        this.startX = e.x;
        this.startY = e.y;
    }

    @Override
    public void onMouseUp(ChartMouseListener.MouseState state) {
        this.active = false;
    }

    @Override
    public void onMouseMove(ChartMouseListener.MouseState state) {
        if (!this.active) {
            return;
        }
        final int diffX = this.startX - state.x;
        this.startX = state.x;
        final int diffY = this.startY - state.y;
        this.startY = state.y;
        final Rectangle rect = this.chartArea.getClientAreaProxy().getClientRectangle();
        boolean update = false;
        this.chartArea.setStale(true);
        if (rect.width > 0) {
            this.processX(new AbstractMouseHandler.AxisFunction<XAxis>(){

                @Override
                public void process(XAxis axis) {
                    axis.transform((long)diffX, rect.width);
                }
            });
            update = true;
        }
        if (rect.height > 0) {
            this.processY(new AbstractMouseHandler.AxisFunction<YAxis>(){

                @Override
                public void process(YAxis axis) {
                    axis.transform((double)diffY, rect.height);
                }
            });
            update = true;
        }
        this.chartArea.setStale(false);
    }
}

