/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.render.legend;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.scada.chart.swt.render.legend.SeriesInformation;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class LegendRenderer
implements Renderer {
    public static final String PROP_TIMETSAMP_FORMAT = "timestampFormat";
    private static final Point EMPTY_POINT = new Point(0, 0);
    private final IObservableList infos;
    private IListChangeListener listener;
    private final int textPadding = 5;
    private final int padding = 10;
    private final int margin = 10;
    private final List<Entry> entries = new ArrayList<Entry>();
    private final ChartRenderer renderer;
    private String timestampFormat;
    private DateFormat timestampFormatImpl;
    private final NumberFormat qualityFormatImpl = NumberFormat.getPercentInstance();
    private final NumberFormat valueFormatImpl = NumberFormat.getNumberInstance();
    private final int previewSize = 15;

    public static int max(int firstValue, int ... values) {
        int v = firstValue;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int nv = nArray[n2];
            if (nv > v) {
                v = nv;
            }
            ++n2;
        }
        return v;
    }

    public LegendRenderer(ChartRenderer renderer, IObservableList informations) {
        this.renderer = renderer;
        this.infos = informations;
        this.setTimestampFormat(null);
        this.listener = new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                LegendRenderer.this.processListChange(event.diff);
            }
        };
        this.infos.addListChangeListener(this.listener);
        int i = 0;
        for (Object o : this.infos) {
            this.addEntry(i, o);
            ++i;
        }
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
        if (timestampFormat == null) {
            this.timestampFormatImpl = DateFormat.getDateTimeInstance();
        } else {
            try {
                this.timestampFormatImpl = new SimpleDateFormat(timestampFormat);
            }
            catch (Exception exception) {
                this.timestampFormatImpl = DateFormat.getDateTimeInstance();
            }
        }
        this.renderer.refresh();
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    protected void processListChange(ListDiff diff) {
        diff.accept(new ListDiffVisitor(){

            public void handleRemove(int index, Object element) {
                Iterator i = LegendRenderer.this.entries.iterator();
                while (i.hasNext()) {
                    Entry next = (Entry)i.next();
                    if (next != element) continue;
                    i.remove();
                    next.dispose();
                }
            }

            public void handleAdd(int index, Object element) {
                LegendRenderer.this.addEntry(index, element);
            }
        });
        this.renderer.refresh();
    }

    public void dispose() {
        this.infos.removeListChangeListener(this.listener);
    }

    protected void addEntry(int index, Object element) {
        this.entries.add(new Entry(index, (SeriesInformation)element));
    }

    @Override
    public void render(Graphics g, Rectangle clientRectangle) {
        Rectangle chartRect = this.renderer.getClientAreaProxy().getClientRectangle();
        DataSet data = this.makeAllData(g);
        this.renderData(g, chartRect, data);
    }

    private void renderData(Graphics g, Rectangle chartRect, DataSet data) {
        int y = chartRect.y + 10;
        int x = chartRect.x + 10;
        g.setAntialias(true);
        g.setForeground(new RGB(180, 180, 180));
        g.setBackground(new RGB(240, 240, 240));
        g.fillRoundRectangle(x, y, data.width + 10 * 2, data.height + 10 * 2, 10, 10);
        g.drawRoundRectangle(x, y, data.width + 10 * 2, data.height + 10 * 2, 10, 10);
        x += 10;
        y += 10;
        g.setForeground(new RGB(0, 0, 0));
        for (Data d : data.allData) {
            this.renderDataEntry(g, data, d, x, y);
            y += Math.max(d.getHeight(), 15) + 5;
        }
    }

    private void renderDataEntry(Graphics g, DataSet data, Data d, int x, int y) {
        g.setBackground(d.color);
        g.fillRectangle(x, y, 15, 15);
        g.drawRectangle(x, y, 15, 15);
        x += 15 + 5;
        if (d.name != null) {
            g.drawText(d.name, x, y, null);
        }
        x += data.maxNameSize + 5;
        int off = data.maxValueSize - d.valueSize.x;
        if (d.value != null) {
            g.drawText(d.value, x + off, y, null);
        }
        x += data.maxValueSize + 5;
        if (d.timestamp != null) {
            g.drawText(d.timestamp, x, y, null);
        }
        x += data.maxTimestampSize + 5;
        if (d.quality != null) {
            g.drawText(d.quality, x, y, null);
        }
        x += data.maxQualitySize + 5;
    }

    protected DataSet makeAllData(Graphics g) {
        DataSet result = new DataSet();
        result.allData = new ArrayList<Data>(this.entries.size());
        for (Entry entry : this.entries) {
            SeriesInformation info = entry.getInformation();
            if (!info.isVisible()) continue;
            Data data = this.makeData(info, g);
            result.height += Math.max(data.getHeight(), 15);
            result.maxNameSize = Math.max(result.maxNameSize, data.nameSize.x);
            result.maxValueSize = Math.max(result.maxValueSize, data.valueSize.x);
            result.maxTimestampSize = Math.max(result.maxTimestampSize, data.timestampSize.x);
            result.maxQualitySize = Math.max(result.maxQualitySize, data.qualitySize.x);
            result.allData.add(data);
        }
        int len = result.allData.size();
        if (len > 1) {
            result.height += (len - 1) * 5;
        }
        result.width = 15 + result.maxNameSize + result.maxQualitySize + result.maxTimestampSize + result.maxValueSize + 5 * 4;
        return result;
    }

    protected Data makeData(SeriesInformation info, Graphics g) {
        Data data = new Data();
        data.color = info.getColor();
        data.name = info.getLabel();
        data.value = this.makeValue(info);
        data.timestamp = this.makeTimestamp(info);
        data.quality = this.makeQuality(info);
        data.nameSize = this.makeSize(g, data.name);
        data.valueSize = this.makeSize(g, data.value);
        data.timestampSize = this.makeSize(g, data.timestamp);
        data.qualitySize = this.makeSize(g, data.quality);
        return data;
    }

    private Point makeSize(Graphics g, String string) {
        if (string == null) {
            return EMPTY_POINT;
        }
        return g.textExtent(string);
    }

    private String makeTimestamp(SeriesInformation info) {
        Calendar timestamp = info.getSelectedTimestamp();
        if (timestamp != null) {
            this.timestampFormatImpl.setCalendar(timestamp);
            return this.timestampFormatImpl.format(timestamp.getTime());
        }
        return null;
    }

    private String makeValue(SeriesInformation info) {
        Double value = info.getSelectedValue();
        if (value == null) {
            return null;
        }
        if (Double.isNaN(value)) {
            return "NaN";
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return "-\u221e";
        }
        if (value == Double.POSITIVE_INFINITY) {
            return "+\u221e";
        }
        return this.valueFormatImpl.format(value);
    }

    private String makeQuality(SeriesInformation info) {
        Double quality = info.getSelectedQuality();
        if (quality != null) {
            return this.qualityFormatImpl.format(quality);
        }
        return null;
    }

    @Override
    public Rectangle resize(ResourceManager resourceManager, Rectangle clientRectangle) {
        return null;
    }

    private static class Data {
        RGB color;
        String name;
        String value;
        String timestamp;
        String quality;
        Point nameSize;
        Point valueSize;
        Point timestampSize;
        Point qualitySize;

        private Data() {
        }

        int getHeight() {
            return LegendRenderer.max(this.nameSize.y, this.valueSize.y, this.timestampSize.y, this.qualitySize.y);
        }
    }

    private static class DataSet {
        List<Data> allData;
        int height;
        int maxNameSize;
        int maxValueSize;
        int maxTimestampSize;
        int maxQualitySize;
        int width;

        private DataSet() {
        }
    }

    private class Entry
    implements Comparable<Entry>,
    IValueChangeListener {
        private final int index;
        private final SeriesInformation information;
        private final Set<IObservableValue> values = new HashSet<IObservableValue>();

        public Entry(int index, SeriesInformation information) {
            this.index = index;
            this.information = information;
            this.addListener(BeansObservables.observeValue((Object)information, (String)"label"));
            this.addListener(BeansObservables.observeValue((Object)information, (String)"selectedQuality"));
            this.addListener(BeansObservables.observeValue((Object)information, (String)"selectedValue"));
            this.addListener(BeansObservables.observeValue((Object)information, (String)"selectedTimestamp"));
        }

        private void addListener(IObservableValue value) {
            this.values.add(value);
            value.addValueChangeListener((IValueChangeListener)this);
        }

        public void dispose() {
            for (IObservableValue v : this.values) {
                v.removeValueChangeListener((IValueChangeListener)this);
            }
        }

        @Override
        public int compareTo(Entry o) {
            return Integer.compare(this.index, o.index);
        }

        public SeriesInformation getInformation() {
            return this.information;
        }

        public void handleValueChange(ValueChangeEvent event) {
            LegendRenderer.this.renderer.refresh();
        }
    }
}

