/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.render;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.Helper;
import org.eclipse.scada.chart.swt.render.AbstractRenderer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class XAxisDynamicRenderer
extends AbstractRenderer {
    private static final Point EMPTY_POINT = new Point(0, 0);
    protected final LineAttributes lineAttributes;
    protected int labelSpacing;
    private XAxis axis;
    private boolean bottom = true;
    private Long step;
    private String format = "%tc";
    private int height = -1;
    private Rectangle rect;
    private final int markerSize = 5;
    private int textPadding = 5;
    private final ChartRenderer chart;
    private boolean showLabels;
    private final int markerSpacing = 0;
    private RGB color;
    private DateFormat formatInstance;
    private long lastFormatTimeRange;

    public XAxisDynamicRenderer(ChartRenderer chart) {
        super(chart);
        this.chart = chart;
        this.lineAttributes = new LineAttributes(1.0f, 1, 3, 1, new float[0], 0.0f, 0.0f);
        this.labelSpacing = 20;
    }

    public void setColor(RGB color) {
        this.color = color;
        this.redraw();
    }

    public RGB getColor() {
        return this.color;
    }

    public void setAlign(int alignment) {
        this.bottom = (alignment & 0x80) != 128;
        this.relayoutParent();
    }

    public void setHeight(int height) {
        this.height = height;
        this.relayoutParent();
    }

    public void setFormat(String format) {
        this.format = format;
        this.formatInstance = null;
        this.relayoutParent();
    }

    public String getFormat() {
        return this.format;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
        this.relayoutParent();
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public int getHeight() {
        return this.height;
    }

    public void setTextPadding(int textPadding) {
        this.textPadding = textPadding;
        this.relayoutParent();
    }

    public int getTextPadding() {
        return this.textPadding;
    }

    public void setStep(Long step) {
        this.step = step;
        this.relayoutParent();
    }

    public Long getStep() {
        return this.step;
    }

    @Override
    public void dispose() {
        this.setAxis(null);
        super.dispose();
    }

    public void setAxis(XAxis axis) {
        if (this.axis != null) {
            this.axis.removePropertyChangeListener(this.propertyChangeListener);
            this.axis = null;
        }
        this.axis = axis;
        if (this.axis != null) {
            this.axis.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.relayoutParent();
    }

    @Override
    public void render(Graphics g, Rectangle clientRectangle) {
        List<Helper.Entry<Long>> markers;
        if (this.rect.width == 0 || this.rect.height == 0 || this.axis == null) {
            return;
        }
        g.setLineAttributes(this.lineAttributes);
        g.setForeground(this.color);
        g.setAntialias(true);
        int y = this.bottom ? this.rect.y : this.rect.y + this.rect.height;
        Rectangle chartRect = this.chart.getClientAreaProxy().getClientRectangle();
        String label = this.axis.getLabel();
        if (label != null) {
            Point size = g.textExtent(label);
            int n = this.rect.x + this.rect.width / 2 - size.x / 2;
            g.drawText(label, n, this.bottom ? this.rect.y + this.rect.height - (size.y + this.textPadding) : this.rect.y + this.textPadding, null);
        }
        if (this.showLabels) {
            DateFormat dateFormat = this.makeFormat(this.axis.getMax() - this.axis.getMin());
            Point sampleLabelSize = g.textExtent(dateFormat.format(new Date()));
            markers = Helper.chartTimes(this.axis.getMin(), this.axis.getMax(), chartRect.width, (int)Math.round(1.5 * (double)sampleLabelSize.x) + 0, dateFormat);
            for (Helper.Entry<Long> marker : markers) {
                if (marker.position < 0) continue;
                int x = chartRect.x + marker.position;
                g.drawText(marker.label, x, this.bottom ? this.rect.y + 5 + this.textPadding : this.rect.y + this.rect.height - (sampleLabelSize.y + this.textPadding), null);
            }
        } else {
            markers = null;
        }
        g.setAntialias(false);
        g.drawLine(chartRect.x, y + (this.bottom ? 0 : -1), chartRect.x + chartRect.width, y + (this.bottom ? 0 : -1));
        if (this.showLabels) {
            for (Helper.Entry entry : markers) {
                if (entry.position < 0) continue;
                int x = chartRect.x + entry.position;
                g.drawLine(x, y, x, this.bottom ? y + 5 : y - 5);
            }
        }
        g.setAntialias(true);
    }

    @Override
    public Rectangle resize(ResourceManager resourceManager, Rectangle clientRectangle) {
        int height;
        int n = height = this.height >= 0 ? this.height : this.calcHeight(resourceManager);
        if (this.bottom) {
            this.rect = new Rectangle(clientRectangle.x, clientRectangle.y + clientRectangle.height - height, clientRectangle.width, height);
            return new Rectangle(clientRectangle.x, clientRectangle.y, clientRectangle.width, clientRectangle.height - height);
        }
        this.rect = new Rectangle(clientRectangle.x, clientRectangle.y, clientRectangle.width, height);
        return new Rectangle(clientRectangle.x, clientRectangle.y + height, clientRectangle.width, clientRectangle.height - height);
    }

    private DateFormat makeFormat(long timeRange) {
        if (this.lastFormatTimeRange != timeRange) {
            this.formatInstance = null;
            this.lastFormatTimeRange = timeRange;
        }
        if (this.formatInstance != null) {
            return this.formatInstance;
        }
        this.formatInstance = this.createFormatInstance(timeRange);
        return this.formatInstance;
    }

    protected DateFormat createFormatInstance(long timeRange) {
        if (this.hasFormat()) {
            try {
                return new SimpleDateFormat(this.format);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return DateFormat.getInstance();
            }
        }
        return Helper.makeFormat(timeRange);
    }

    protected boolean hasFormat() {
        return this.format != null && !this.format.isEmpty();
    }

    private int calcHeight(ResourceManager resourceManager) {
        if (this.axis == null) {
            return 0;
        }
        GC gc = new GC((Drawable)resourceManager.getDevice());
        try {
            gc.setFont(this.makeFont(resourceManager));
            DateFormat format = this.makeFormat(this.axis.getMax() - this.axis.getMin());
            Point markerSize = this.getExtent(gc, format.format(new Date()));
            Point labelSize = this.getExtent(gc, this.axis.getLabel());
            int height = markerSize.y + labelSize.y + this.textPadding * 2 + 5;
            if (labelSize.y > 0) {
                height += this.textPadding;
            }
            int n = height;
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    private Font makeFont(ResourceManager resourceManager) {
        return null;
    }

    private Point getExtent(GC gc, String string) {
        if (string == null || string.isEmpty()) {
            return EMPTY_POINT;
        }
        return gc.textExtent(string);
    }
}

