/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.chart.swt.ChartAreaRenderer;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.SWTGraphics;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ChartArea
extends Canvas {
    private final ChartRenderer chartRenderer = new ChartAreaRenderer((Composite)this);
    private final LocalResourceManager resourceManager;

    public ChartArea(Composite parent, int style) {
        super(parent, 0x20000000);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ChartArea.this.onDispose();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ChartArea.this.onPaint(e);
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ChartArea.this.resizeAll(ChartArea.this.getClientArea());
            }
        });
    }

    public ChartRenderer getChartRenderer() {
        return this.chartRenderer;
    }

    protected void resizeAll(Rectangle clientArea) {
        this.chartRenderer.resizeAll(clientArea);
    }

    protected void onDispose() {
        this.resourceManager.dispose();
        this.chartRenderer.dispose();
    }

    protected void onPaint(PaintEvent e) {
        SWTGraphics g = new SWTGraphics(e.gc, (ResourceManager)this.resourceManager);
        try {
            this.chartRenderer.paint(g);
        }
        finally {
            g.dispose();
        }
    }
}

