/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.render;

import java.util.NavigableSet;
import org.eclipse.scada.chart.DataEntry;
import org.eclipse.scada.chart.SeriesData;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.DataPoint;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.render.AbstractLineRender;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;

public class LinearRenderer
extends AbstractLineRender
implements Renderer {
    public LinearRenderer(ChartRenderer chartArea, SeriesData abstractSeriesData) {
        super(chartArea, abstractSeriesData);
    }

    @Override
    protected void performRender(Graphics g, Rectangle clientRect) {
        Path path = g.createPath();
        try {
            XAxis xAxis = this.seriesData.getXAxis();
            YAxis yAxis = this.seriesData.getYAxis();
            NavigableSet entries = this.seriesData.getViewData().getEntries();
            if (entries.isEmpty()) {
                return;
            }
            boolean first = true;
            DataPoint point = new DataPoint();
            for (DataEntry entry : entries) {
                boolean hasData = LinearRenderer.translateToPoint(clientRect, xAxis, yAxis, point, entry);
                if (hasData) {
                    if (first) {
                        first = false;
                        path.moveTo(point.x, point.y);
                        continue;
                    }
                    path.lineTo(point.x, point.y);
                    continue;
                }
                first = true;
            }
            g.setAlpha(255);
            g.setLineAttributes(this.lineAttributes);
            g.setForeground(this.lineColor);
            g.setClipping(clientRect);
            g.drawPath(path);
        }
        finally {
            path.dispose();
        }
    }
}

