/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.render;

import java.util.NavigableSet;
import org.eclipse.scada.chart.DataEntry;
import org.eclipse.scada.chart.SeriesData;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.DataPoint;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.render.AbstractLineRender;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepRenderer
extends AbstractLineRender
implements Renderer {
    private static final Logger logger = LoggerFactory.getLogger(StepRenderer.class);
    private boolean noFuture;
    private final ChartRenderer chartArea;

    public StepRenderer(ChartRenderer chartArea, SeriesData abstractSeriesData) {
        super(chartArea, abstractSeriesData);
        this.chartArea = chartArea;
    }

    public void setNoFuture(boolean noFuture) {
        this.noFuture = noFuture;
        this.chartArea.refresh();
    }

    public boolean isNoFuture() {
        return this.noFuture;
    }

    @Override
    protected void performRender(Graphics g, Rectangle clientRect) {
        XAxis xAxis = this.seriesData.getXAxis();
        YAxis yAxis = this.seriesData.getYAxis();
        NavigableSet entries = this.seriesData.getViewData().getEntries();
        if (entries.isEmpty()) {
            return;
        }
        Path path = g.createPath();
        try {
            boolean first = true;
            DataPoint point = new DataPoint();
            Float previousX = null;
            Float previousY = null;
            logger.trace("Render steps");
            long now = System.currentTimeMillis();
            for (DataEntry entry : entries) {
                boolean skip;
                boolean hasData = StepRenderer.translateToPoint(clientRect, xAxis, yAxis, point, entry);
                logger.trace("Entry - {}, hasData: {}, point: {}", new Object[]{entry, hasData, point});
                boolean bl = skip = this.noFuture && entry.getTimestamp() > now;
                if (hasData && !skip) {
                    if (first) {
                        first = false;
                        path.moveTo(point.x, point.y);
                    } else if (previousX != null && previousX.floatValue() + 1.0f == point.x) {
                        path.lineTo(point.x, point.y);
                    } else {
                        path.lineTo(point.x, previousY.floatValue());
                        path.lineTo(point.x, point.y);
                    }
                    previousX = Float.valueOf(point.x);
                    previousY = Float.valueOf(point.y);
                    continue;
                }
                first = true;
                if (previousY != null) {
                    path.lineTo(point.x, previousY.floatValue());
                    previousY = null;
                }
                previousX = null;
            }
            g.setAlpha(255);
            g.setLineAttributes(this.lineAttributes);
            g.setForeground(this.lineColor);
            g.setAntialias(true);
            g.setClipping(clientRect);
            g.drawPath(path);
        }
        finally {
            path.dispose();
        }
    }
}

