/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.render;

import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.render.AbstractRuler;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AbstractPositionYRuler
extends AbstractRuler {
    protected YAxis axis;
    private int style;

    public AbstractPositionYRuler(YAxis axis, int style) {
        this.axis = axis;
        this.style = style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setAxis(YAxis axis) {
        this.axis = axis;
    }

    public abstract Double getPosition();

    @Override
    protected void doRender(Graphics g, Rectangle clientRectangle) {
        if (this.axis == null) {
            return;
        }
        Double position = this.getPosition();
        if (position == null) {
            return;
        }
        int y = (int)this.axis.translateToClient(clientRectangle.height, this.getPosition().doubleValue());
        if ((this.style & 0x80) > 0) {
            g.fillRectangle(clientRectangle.x, clientRectangle.y, clientRectangle.width, y);
        } else if ((this.style & 0x400) > 0) {
            g.fillRectangle(clientRectangle.x, y, clientRectangle.width, clientRectangle.height - y);
        } else {
            if (y < 0 || y > clientRectangle.width) {
                return;
            }
            g.drawLine(clientRectangle.x, clientRectangle.y + y, clientRectangle.width, clientRectangle.y + y);
        }
    }
}

