/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.controller;

import org.eclipse.scada.chart.swt.ChartMouseListener;
import org.eclipse.scada.chart.swt.ChartMouseMoveListener;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.DisposeListener;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.render.AbstractRuler;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class MouseHover
extends AbstractRuler
implements ChartMouseMoveListener {
    private final ChartRenderer chart;
    private Integer position;
    private final RGB color = new RGB(0, 0, 0);

    public MouseHover(ChartRenderer chart) {
        this.chart = chart;
        chart.addDisposeListener(new DisposeListener(){

            @Override
            public void onDispose() {
                MouseHover.this.dispose();
            }
        });
        chart.addMouseMoveListener(this);
        chart.addRenderer(this);
    }

    public void dispose() {
        this.chart.removeRenderer(this);
        this.chart.removeMouseMoveListener(this);
    }

    @Override
    public void onMouseMove(ChartMouseListener.MouseState state) {
        Rectangle rect = this.chart.getClientAreaProxy().getClientRectangle();
        int x = state.x;
        int y = state.y;
        this.position = null;
        if (x < rect.x || x > rect.x + rect.width) {
            return;
        }
        if (y < rect.y || y > rect.y + rect.height) {
            return;
        }
        this.position = x;
        if (this.visible) {
            this.chart.refresh();
        }
    }

    @Override
    protected void doRender(Graphics g, Rectangle clientRectangle) {
        if (this.position == null) {
            return;
        }
        int x = this.position;
        g.setForeground(this.color);
        g.drawLine(x, clientRectangle.y, x, clientRectangle.y + clientRectangle.height);
    }

    public static interface Listener {
        public void mouseMove(ChartMouseListener.MouseState var1, long var2);
    }
}

