/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.render;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scada.chart.Realm;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.swt.SWT;

public abstract class AbstractRenderer
implements Renderer {
    private boolean disposed = false;
    private final ChartRenderer chart;
    protected PropertyChangeListener propertyChangeListener;
    private final Realm realm;

    public AbstractRenderer(ChartRenderer chart) {
        this.chart = chart;
        this.realm = chart.getRealm();
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractRenderer.this.handlePropertyChange(evt);
            }
        };
    }

    protected void handlePropertyChange(PropertyChangeEvent evt) {
        this.relayoutParent();
    }

    protected void relayoutParent() {
        if (this.chart.isDisposed()) {
            return;
        }
        this.checkWidget();
        this.chart.relayout();
        this.chart.refresh();
    }

    public void dispose() {
        if (!this.disposed) {
            this.chart.removeRenderer(this);
            this.relayoutParent();
            this.disposed = true;
        }
    }

    protected void redraw() {
        this.checkWidget();
        this.chart.refresh();
    }

    protected void checkWidget() {
        try {
            this.realm.checkRealm();
        }
        catch (IllegalAccessException e) {
            SWT.error((int)22, (Throwable)e);
        }
    }
}

