/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.render;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.render.AbstractRenderer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class TitleRenderer
extends AbstractRenderer {
    private final Map<Device, Font> fontCache = new HashMap<Device, Font>();
    private String title;
    private int padding = 10;
    private Rectangle rect;
    private int fontSize = -1;

    public TitleRenderer(ChartRenderer chart) {
        super(chart);
    }

    @Override
    public void dispose() {
        for (Font font : this.fontCache.values()) {
            font.dispose();
        }
        this.fontCache.clear();
        super.dispose();
    }

    public void setTitle(String title) {
        this.title = title;
        this.relayoutParent();
    }

    public String getTitle() {
        return this.title;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.relayoutParent();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setPadding(int padding) {
        this.padding = padding;
        this.relayoutParent();
    }

    public int getPadding() {
        return this.padding;
    }

    @Override
    public void render(Graphics g, Rectangle clientRectangle) {
        if (this.title == null || this.title.isEmpty()) {
            return;
        }
        g.setClipping(this.rect);
        g.setFont(this.createFont(g.getResourceManager()));
        Point size = g.textExtent(this.title);
        int x = this.rect.width / 2 - size.x / 2;
        int y = this.padding;
        g.drawText(this.title, this.rect.x + x, this.rect.y + y, null);
        g.setClipping(clientRectangle);
    }

    @Override
    public Rectangle resize(ResourceManager resourceManager, Rectangle clientRectangle) {
        if (this.title == null || this.title.isEmpty()) {
            return null;
        }
        GC gc = new GC((Drawable)resourceManager.getDevice());
        gc.setFont(this.createFont(resourceManager));
        try {
            Point size = gc.textExtent(this.title);
            this.rect = new Rectangle(clientRectangle.x, clientRectangle.y, clientRectangle.width, size.y + this.padding * 2);
            Rectangle rectangle = new Rectangle(clientRectangle.x, this.rect.y + this.rect.height, clientRectangle.width, clientRectangle.height - this.rect.height);
            return rectangle;
        }
        finally {
            gc.dispose();
        }
    }

    private Font createFont(ResourceManager resourceManager) {
        Font defaultFont = resourceManager.getDevice().getSystemFont();
        if (defaultFont == null) {
            return null;
        }
        FontData[] fd = FontDescriptor.copy((FontData[])defaultFont.getFontData());
        if (fd == null) {
            return null;
        }
        FontData[] fontDataArray = fd;
        int n = fd.length;
        int n2 = 0;
        while (n2 < n) {
            FontData f = fontDataArray[n2];
            if (this.fontSize > 0) {
                f.setHeight(this.fontSize);
            }
            ++n2;
        }
        return resourceManager.createFont(FontDescriptor.createFrom((FontData[])fd));
    }
}

