/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.osgi.modbus;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.scada.da.server.common.memory.AbstractRequestBlock;
import org.eclipse.scada.da.server.osgi.modbus.ModbusSlave;
import org.eclipse.scada.da.server.osgi.modbus.Request;
import org.eclipse.scada.da.server.osgi.modbus.RequestType;
import org.eclipse.scada.protocol.modbus.io.ChecksumProtocolException;
import org.eclipse.scada.protocol.modbus.message.ErrorResponse;
import org.eclipse.scada.protocol.modbus.message.ReadResponse;
import org.eclipse.scada.protocol.modbus.message.WriteMultiDataRequest;
import org.eclipse.scada.protocol.modbus.message.WriteSingleDataRequest;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ModbusRequestBlock
extends AbstractRequestBlock {
    private static final Logger logger = LoggerFactory.getLogger(ModbusRequestBlock.class);
    private final Request request;
    private final ModbusSlave slave;
    private final String id;
    private AtomicInteger transactionId;

    public ModbusRequestBlock(Executor executor, String id, String name, String mainTypeName, ModbusSlave slave, BundleContext context, Request request, AtomicInteger transactionId, boolean enableStatistics) {
        super(context, executor, mainTypeName, "modbus.data." + id, "modbus.block." + id, enableStatistics, request.getPeriod(), request.getCount(), slave.getTimeoutQuietPeriod(), request.isEager());
        this.id = id;
        this.request = request;
        this.slave = slave;
        this.transactionId = transactionId;
        this.initialize();
    }

    public long getPollRequestTimeout() {
        return this.request.getTimeout();
    }

    public Request getRequest() {
        return this.request;
    }

    public String toString() {
        return String.format("[Request - %s]", this.request);
    }

    public synchronized void handleFailure(Throwable e) {
        if (e instanceof ChecksumProtocolException) {
            this.recordChecksumError();
        }
        super.handleFailure(e);
    }

    public boolean handleMessage(Object message) {
        MDC.put((String)"modbus.block", (String)this.id);
        try {
            logger.debug("Handle message - message: {}", message);
            if (message instanceof ErrorResponse) {
                logger.debug("Handle error");
                byte slaveAddress = ((ErrorResponse)message).getUnitIdentifier();
                if (this.slave.getSlaveAddress() != slaveAddress) {
                    logger.info("Reply was not for us");
                    return false;
                }
                this.handleError(((ErrorResponse)message).getExceptionCode());
                return true;
            }
            if (message instanceof ReadResponse) {
                logger.debug("Handle data");
                byte slaveAddress = ((ReadResponse)message).getUnitIdentifier();
                if (this.slave.getSlaveAddress() != slaveAddress) {
                    logger.info("Reply was not for us (we: {}, they: {})", (Object)this.slave.getSlaveAddress(), (Object)slaveAddress);
                    return false;
                }
                this.handleData(((ReadResponse)message).getData());
                return true;
            }
            logger.info("Unknown message");
            return false;
        }
        finally {
            MDC.remove((String)"modbus.block");
        }
    }

    public Object createPollRequest() {
        return this.slave.createPollRequest(this.transactionId.incrementAndGet(), this.request);
    }

    public int getStartAddress() {
        return this.request.getStartAddress();
    }

    private int toGlobalAddress(int blockAddress) {
        return this.request.getStartAddress() + blockAddress;
    }

    public void writeBit(int blockAddress, int subIndex, boolean value) {
        if (this.request.getType() != RequestType.COIL) {
            throw new IllegalStateException(String.format("Modbus can only write bits when the block is of type %s", new Object[]{RequestType.COIL}));
        }
        this.slave.writeCommand(new WriteSingleDataRequest(this.transactionId.incrementAndGet(), this.slave.getSlaveAddress(), 5, this.toGlobalAddress(blockAddress * 8 + subIndex), value), this.request.getTimeout());
        this.requestUpdate();
    }

    public void writeData(int blockAddress, byte[] data) {
        if (this.request.getType() != RequestType.HOLDING) {
            throw new IllegalStateException(String.format("Modbus can only write data when the block is of type %s", new Object[]{RequestType.HOLDING}));
        }
        if (data.length == 2) {
            int value = ByteBuffer.wrap(data).getShort() & 0xFFFF;
            this.slave.writeCommand(new WriteSingleDataRequest(this.transactionId.incrementAndGet(), this.slave.getSlaveAddress(), 6, this.toGlobalAddress(blockAddress), value), this.request.getTimeout());
        } else {
            this.slave.writeCommand(new WriteMultiDataRequest(this.transactionId.incrementAndGet(), this.slave.getSlaveAddress(), 16, this.toGlobalAddress(blockAddress), data), this.request.getTimeout());
        }
        this.requestUpdate();
    }
}

