/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master.analyzer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.connection.provider.info.ConnectionInformationProvider;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.master.analyzer.ConnectionAnalyzerStatus;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.chain.WriteHandler;
import org.eclipse.scada.da.server.common.exporter.StaticObjectExporter;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;
import org.eclipse.scada.da.server.common.osgi.factory.DataItemFactory;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.scada.utils.stats.StatisticEntry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ConnectionAnalyzer
implements ConnectionStateListener {
    private static final long STATISTICS_DELAY = Long.getLong("org.eclipse.scada.da.master.analyzer.statisticsDelay", 5L);
    private final DataItemFactory factory;
    private final StaticObjectExporter<ConnectionAnalyzerStatus> exporter;
    private final ConnectionAnalyzerStatus value;
    private final ConnectionService service;
    private final ScheduledFuture<?> job;
    private final DataItemInputChained statisticsItem;

    public ConnectionAnalyzer(ScheduledExecutorService executor, BundleContext context, ServiceReference<?> reference, ConnectionService service) {
        this.factory = new DataItemFactory(context, (Executor)executor, "org.eclipse.scada.da.master.analyzer.connectionService." + ConnectionAnalyzer.makeId(reference));
        this.exporter = new StaticObjectExporter((ItemFactory)this.factory, ConnectionAnalyzerStatus.class, false, false, "state.");
        this.statisticsItem = this.factory.createInput("statistics", null);
        this.value = new ConnectionAnalyzerStatus();
        this.value.setUri(this.makeUri(service));
        this.exporter.setTarget((Object)this.value);
        this.job = executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ConnectionAnalyzer.this.refresh();
            }
        }, 0L, STATISTICS_DELAY, TimeUnit.SECONDS);
        this.factory.createOutput("connect", null, new WriteHandler(){

            public void handleWrite(Variant value, OperationParameters operationParameters) throws Exception {
                ConnectionAnalyzer.this.handleConnect();
            }
        });
        this.factory.createOutput("disconnect", null, new WriteHandler(){

            public void handleWrite(Variant value, OperationParameters operationParameters) throws Exception {
                ConnectionAnalyzer.this.handleDisconnect();
            }
        });
        this.service = service;
        this.stateChange(service.getConnection(), service.getConnection().getState(), null);
        service.getConnection().addConnectionStateListener((ConnectionStateListener)this);
    }

    protected void refresh() {
        HashMap<String, Variant> result = new HashMap<String, Variant>();
        if (this.service instanceof ConnectionInformationProvider) {
            Collection statistics = ((ConnectionInformationProvider)this.service).getStatistics();
            for (StatisticEntry entry : statistics) {
                try {
                    result.put(String.format("statistics.%s.current", entry.getLabel()), Variant.valueOf((Object)entry.getValue().getCurrent()));
                    result.put(String.format("statistics.%s.min", entry.getLabel()), Variant.valueOf((Object)entry.getValue().getMinimum()));
                    result.put(String.format("statistics.%s.max", entry.getLabel()), Variant.valueOf((Object)entry.getValue().getMaximum()));
                }
                catch (Exception exception) {}
            }
            this.statisticsItem.updateData(this.makeJson(statistics), result, AttributeMode.SET);
        }
    }

    private Variant makeJson(Collection<StatisticEntry> statistics) {
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        return Variant.valueOf((Object)gson.toJson(statistics));
    }

    private String makeUri(ConnectionService service) {
        ConnectionInformation info;
        Connection connection;
        if (service != null && (connection = service.getConnection()) != null && (info = connection.getConnectionInformation()) != null) {
            return info.toMaskedString();
        }
        return null;
    }

    protected void handleDisconnect() {
        ConnectionService service = this.service;
        if (service != null) {
            service.disconnect();
        }
    }

    protected void handleConnect() {
        ConnectionService service = this.service;
        if (service != null) {
            service.connect();
        }
    }

    public void dispose() {
        this.job.cancel(false);
        this.service.getConnection().removeConnectionStateListener((ConnectionStateListener)this);
        this.factory.dispose();
    }

    private static String makeId(ServiceReference<?> reference) {
        Object id = reference.getProperty("service.pid");
        if (id instanceof String) {
            return (String)id;
        }
        return "" + reference.getProperty("service.id");
    }

    public void stateChange(Connection connection, ConnectionState state, Throwable error) {
        this.value.setState(state);
        this.value.setConnected(state == ConnectionState.BOUND);
        this.value.setLastException(ExceptionHelper.formatted((Throwable)error));
        this.value.setLastError(ExceptionHelper.getMessage((Throwable)error));
        this.exporter.setTarget((Object)this.value);
    }
}

