/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.storage.slave.hds;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.scada.hd.server.storage.hds.AbstractStorageManager;
import org.eclipse.scada.hd.server.storage.slave.hds.BaseWatcher;
import org.eclipse.scada.hd.server.storage.slave.hds.StorageImpl;
import org.eclipse.scada.hds.DataFilePool;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageManager
extends AbstractStorageManager {
    private static final Logger logger = LoggerFactory.getLogger(StorageManager.class);
    private final ScheduledExecutorService executor;
    private final ScheduledFuture<?> checkBaseJob;
    private BaseWatcher baseWatcher;
    private final Lock lock = new ReentrantLock();
    private final BundleContext context;
    private final Map<File, StorageImpl> storages = new HashMap<File, StorageImpl>();
    private final DataFilePool pool;
    private final ScheduledExecutorService eventExecutor;

    public StorageManager(BundleContext context, File base, DataFilePool pool, ScheduledExecutorService executor, ScheduledExecutorService eventExecutor) {
        super(base);
        this.context = context;
        this.pool = pool;
        this.executor = executor;
        this.eventExecutor = eventExecutor;
        this.checkBaseJob = this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                StorageManager.this.checkBase();
            }
        }, 0L, Integer.getInteger("org.eclipse.scada.hd.server.storage.slave.hds.checkBaseSeconds", 60).intValue(), TimeUnit.SECONDS);
    }

    protected void checkBase() {
        logger.debug("Checking base {}", (Object)this.base);
        if (this.base.isDirectory() && this.base.canRead()) {
            if (this.baseWatcher == null) {
                logger.info("Base was found ... creating BaseWatcher");
                try {
                    this.baseWatcher = new BaseWatcher(this, this.base);
                }
                catch (IOException e) {
                    logger.warn("Failed to create base watcher", (Throwable)e);
                    this.baseWatcher = null;
                }
            }
        } else if (this.baseWatcher != null) {
            logger.info("Base is gone ... disposing");
            this.baseWatcher.dispose();
        }
    }

    public void dispose() {
        logger.info("Disposing");
        this.checkBaseJob.cancel(false);
        super.dispose();
    }

    public String probe(File file) {
        return super.probe(file);
    }

    public void addStorage(File storageDirectory) throws Exception {
        this.lock.lock();
        try {
            StorageImpl storage = new StorageImpl(this.context, storageDirectory, this.pool, this.queryExecutor, this.eventExecutor);
            this.storages.put(storageDirectory, storage);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeStorage(File storageDirectory) {
        this.lock.lock();
        try {
            StorageImpl storage = this.storages.remove(storageDirectory);
            if (storage != null) {
                storage.dispose();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void fileChanged(File storageDirectory, String id, File fileChanged) {
        this.lock.lock();
        try {
            StorageImpl storage = this.storages.get(storageDirectory);
            if (storage == null) {
                logger.info("Received change notification for unknown storage: {} / {}", (Object)storageDirectory, (Object)fileChanged);
                return;
            }
            storage.fileChanged(fileChanged);
        }
        finally {
            this.lock.unlock();
        }
    }
}

