/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.subscription;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.subscription.SubscriptionInformation;
import org.eclipse.scada.core.subscription.SubscriptionListener;
import org.eclipse.scada.core.subscription.SubscriptionSource;

public class Subscription {
    private final Map<SubscriptionInformation, Object> listeners = new HashMap<SubscriptionInformation, Object>(1);
    private SubscriptionSource source = null;
    private Object topic = null;

    public Subscription(Object topic) {
        this.topic = topic;
    }

    public synchronized boolean isEmpty() {
        return this.source == null && this.listeners.isEmpty();
    }

    public synchronized boolean isGranted() {
        return this.source == null && !this.listeners.isEmpty();
    }

    public synchronized void subscribe(SubscriptionListener listener, Object hint) {
        SubscriptionInformation subscriptionInformation = new SubscriptionInformation(listener, hint);
        if (this.listeners.containsKey(subscriptionInformation)) {
            return;
        }
        this.listeners.put(subscriptionInformation, hint);
        if (this.source == null) {
            listener.updateStatus(this.topic, SubscriptionState.GRANTED);
        } else {
            listener.updateStatus(this.topic, SubscriptionState.CONNECTED);
            this.source.addListener(Arrays.asList(subscriptionInformation));
        }
    }

    public synchronized void unsubscribe(SubscriptionListener listener) {
        SubscriptionInformation subscriptionInformation = new SubscriptionInformation(listener, null);
        if (this.listeners.containsKey(subscriptionInformation)) {
            Object hint = this.listeners.remove(subscriptionInformation);
            subscriptionInformation.setHint(hint);
            if (this.source != null) {
                this.source.removeListener(Arrays.asList(subscriptionInformation));
            }
            listener.updateStatus(this.topic, SubscriptionState.DISCONNECTED);
        }
    }

    public synchronized void setSource(SubscriptionSource source) {
        if (this.source == source) {
            return;
        }
        if (this.source != null) {
            this.source.removeListener(this.listeners.keySet());
        }
        Set<SubscriptionInformation> keys = this.listeners.keySet();
        if (source != null) {
            for (SubscriptionInformation information : keys) {
                information.getListener().updateStatus(this.topic, SubscriptionState.CONNECTED);
            }
            if (!keys.isEmpty()) {
                source.addListener(keys);
            }
        } else {
            for (SubscriptionInformation information : keys) {
                information.getListener().updateStatus(this.topic, SubscriptionState.GRANTED);
            }
        }
        this.source = source;
    }
}

