/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.io;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.session.IoSession;
import org.eclipse.scada.da.server.common.io.PollRequest;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManager {
    private static final Logger logger = LoggerFactory.getLogger(JobManager.class);
    private IoSession session;
    private final Map<String, PollRequest> blocks = new HashMap<String, PollRequest>();
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> job;
    private Job currentJob;
    private final Queue<Job> writeQueue = new ConcurrentLinkedQueue<Job>();
    private ScheduledExecutorService createdExector;

    public JobManager(String threadName) {
        this.executor = this.createdExector = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory(threadName));
    }

    public JobManager(ScheduledExecutorService executor) {
        this.executor = executor;
        this.createdExector = null;
    }

    public synchronized void setSession(IoSession session) {
        logger.debug("Setting session: {}", (Object)session);
        this.session = session;
        this.setTimerState(session != null);
        if (session == null) {
            this.currentJob = null;
            this.writeQueue.clear();
            this.handleDataDisconnected();
        }
    }

    private void setTimerState(boolean flag) {
        boolean currentState;
        boolean bl = currentState = this.job != null;
        if (currentState == flag) {
            logger.info("Timer is in correct state: {} / {}", new Object[]{currentState, flag});
            return;
        }
        if (flag) {
            logger.info("Starting timer");
            this.job = this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    JobManager.this.tick();
                }
            }, 0L, 100L, TimeUnit.MILLISECONDS);
        } else {
            logger.info("Stopping timer");
            this.job.cancel(false);
            this.job = null;
        }
    }

    public synchronized void messageReceived(Object message) {
        logger.trace("messageReceived - currentJob: {}, message: {}", (Object)this.currentJob, message);
        if (this.currentJob != null) {
            try {
                this.currentJob.handleMessage(message);
            }
            finally {
                this.currentJob = null;
                this.startNextJob();
            }
        } else {
            logger.warn("Message without a job: {}", message);
        }
    }

    protected synchronized void tick() {
        if (this.currentJob != null) {
            logger.trace("Ticked with current job");
            if (this.isCurrentJobTimeout()) {
                this.handleTimeout();
            }
            return;
        }
        logger.info("No job active when ticking... adding job!");
        this.startNextJob();
        logger.info("New job: {}", (Object)this.currentJob);
    }

    protected boolean isCurrentJobTimeout() {
        return this.currentJob.getTimeoutTime() > 0L && this.currentJob.getTimeoutTime() < System.currentTimeMillis();
    }

    private void handleTimeout() {
        logger.debug("Job timed out: {}", (Object)this.currentJob);
        this.currentJob.handleTimeout();
        this.currentJob = null;
        this.startNextJob();
    }

    public void handleException(Throwable e) {
        logger.debug("Job exception: {}", (Object)this.currentJob);
        this.currentJob.handleException(e);
        this.currentJob = null;
        this.startNextJob();
    }

    private void startNextJob() {
        this.currentJob = this.getNextWriteJob();
        if (this.currentJob == null) {
            this.currentJob = this.getNextReadJob();
        }
        logger.debug("Next job: {}", (Object)this.currentJob);
        if (this.currentJob != null) {
            this.currentJob.start(this.session);
        }
    }

    private Job getNextReadJob() {
        long now = System.currentTimeMillis();
        PollRequest request = this.findNextBestPollRequest(now);
        if (request != null) {
            return new ReadJob(request);
        }
        return null;
    }

    private PollRequest findNextBestPollRequest(long now) {
        PollRequest nextRequest = null;
        long nextPriority = 0L;
        for (PollRequest request : this.blocks.values()) {
            Long priority = request.updatePriority(now);
            logger.trace("Checking request: {} - {}", (Object)priority, (Object)request);
            if (priority == null) continue;
            if (nextRequest == null) {
                logger.trace("First request");
                nextRequest = request;
                nextPriority = priority;
                continue;
            }
            if (priority <= nextPriority) continue;
            logger.trace("Better request");
            nextRequest = request;
            nextPriority = priority;
        }
        return nextRequest;
    }

    private Job getNextWriteJob() {
        return this.writeQueue.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        JobManager jobManager = this;
        synchronized (jobManager) {
            for (PollRequest block : this.blocks.values()) {
                block.dispose();
            }
            if (this.job != null) {
                this.job.cancel(false);
            }
        }
        if (this.createdExector != null) {
            this.createdExector.shutdown();
        }
    }

    protected void handleDataDisconnected() {
        for (PollRequest block : this.blocks.values()) {
            block.handleDisconnect();
        }
    }

    public synchronized void addBlock(String id, PollRequest block) {
        logger.debug("Adding block: {}", (Object)id);
        if (this.blocks.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Block '%s' is already registered with device", id));
        }
        this.blocks.put(id, block);
    }

    public synchronized void removeBlock(String id) {
        logger.debug("Removing block: {}", (Object)id);
        PollRequest oldBlock = this.blocks.remove(id);
        if (oldBlock != null) {
            logger.debug("Dispose bock: {}", (Object)id);
            oldBlock.dispose();
        }
    }

    public void addWriteRequest(Object request, long timeout) {
        this.writeQueue.add(new WriteJob(request, timeout));
    }

    private static abstract class BaseJob
    implements Job {
        private final long timeoutTime;

        public BaseJob(long timeout) {
            this.timeoutTime = timeout > 0L ? System.currentTimeMillis() + timeout : 0L;
            logger.trace("Job timeout: {} -> {}", (Object)timeout, (Object)this.timeoutTime);
        }

        @Override
        public long getTimeoutTime() {
            return this.timeoutTime;
        }
    }

    private static interface Job {
        public void handleMessage(Object var1);

        public long getTimeoutTime();

        public void start(IoSession var1);

        public void handleTimeout();

        public void handleException(Throwable var1);
    }

    private static class ReadJob
    extends BaseJob {
        private final PollRequest block;

        public ReadJob(PollRequest block) {
            super(block.getPollRequestTimeout());
            this.block = block;
        }

        @Override
        public void handleMessage(Object message) {
            logger.debug("Result: {} - for: {}", message, (Object)this.block);
            if (!this.block.handleMessage(message)) {
                logger.warn("Got wrong message as reply: {}", message);
                this.block.handleFailure(new RuntimeException("Wrong reply"));
            }
        }

        @Override
        public void handleTimeout() {
            this.block.handleTimeout();
        }

        @Override
        public void handleException(Throwable e) {
            this.block.handleFailure(e);
        }

        @Override
        public void start(IoSession session) {
            Object request = this.block.createPollRequest();
            logger.debug("Start request: {}", request);
            session.write(request);
        }

        public String toString() {
            return String.format("[ReadJob: %s, timeoutTime: %s]", this.block, this.getTimeoutTime());
        }
    }

    private static class WriteJob
    extends BaseJob {
        private final Object request;

        public WriteJob(Object request, long timeout) {
            super(timeout);
            this.request = request;
        }

        @Override
        public void start(IoSession session) {
            session.write(this.request);
        }

        @Override
        public void handleTimeout() {
        }

        @Override
        public void handleMessage(Object message) {
        }

        @Override
        public void handleException(Throwable e) {
        }
    }
}

