/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.info;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ae.monitor.MonitorService;
import org.eclipse.scada.ae.server.info.internal.InfoServiceFactory;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.scada.ae.server.info";
    private static Activator plugin;
    private static final Logger logger;
    private ExecutorService executor;
    private ObjectPoolImpl<DataSource> dataSourcePool;
    private InfoServiceFactory factory;
    private ServiceRegistration<ConfigurationFactory> factoryHandle;
    private ServiceRegistration<?> dataSourcePoolHandler;
    private ObjectPoolTracker<MonitorService> monitorPoolTracker;

    static {
        logger = LoggerFactory.getLogger(Activator.class);
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        logger.info("Starting up...");
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(context.getBundle().getSymbolicName()));
        this.monitorPoolTracker = new ObjectPoolTracker(context, MonitorService.class);
        this.monitorPoolTracker.open();
        this.dataSourcePool = new ObjectPoolImpl();
        this.dataSourcePoolHandler = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.dataSourcePool, DataSource.class);
        this.factory = new InfoServiceFactory(context, this.executor, this.monitorPoolTracker, this.dataSourcePool);
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("service.description", "An aggregator for all monitor states");
        ((Dictionary)properties).put("factoryId", "ae.server.info");
        this.factoryHandle = context.registerService(ConfigurationFactory.class, (Object)this.factory, properties);
    }

    public void stop(BundleContext context) throws Exception {
        this.factoryHandle.unregister();
        this.factory.dispose();
        this.factory = null;
        this.dataSourcePoolHandler.unregister();
        this.executor.shutdown();
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }
}

