/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ngp.common;

import java.util.Map;
import org.apache.mina.filter.ssl.SslContextFactory;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfiguration;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfigurationFactory;
import org.eclipse.scada.protocol.ngp.common.SslHelper;
import org.eclipse.scada.protocol.ngp.common.mc.protocol.ProtocolDescriptor;
import org.eclipse.scada.protocol.ngp.common.mc.protocol.serialize.ObjectSerializationProtocolDescriptor;

public class DefaultProtocolConfigurationFactory
implements ProtocolConfigurationFactory {
    protected final ConnectionInformation connectionInformation;

    public DefaultProtocolConfigurationFactory(ConnectionInformation connectionInformation) {
        this.connectionInformation = connectionInformation;
    }

    public ProtocolConfiguration createConfiguration(boolean clientMode) throws Exception {
        ProtocolConfiguration configuration = new ProtocolConfiguration();
        configuration.setStreamCompressionLevel(this.getInteger("streamCompressionLevel", this.connectionInformation.getProperties(), 9).intValue());
        configuration.setSslContextFactory(this.makeSslContextFactory(clientMode));
        configuration.setTimeout(this.getInteger("timeout", this.connectionInformation.getProperties(), configuration.getTimeout()).intValue());
        configuration.setPingFrequency(this.getInteger("pingFrequency", this.connectionInformation.getProperties(), configuration.getPingFrequency()).intValue());
        this.customizeConfiguration(configuration, clientMode);
        return configuration;
    }

    private Integer getInteger(String key, Map<String, String> properties, Integer defaultValue) {
        String value = properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    protected void addJavaProtocol(String protocolVersion, ProtocolConfiguration configuration, ClassLoader classLoader) {
        this.addProtocol(configuration, (ProtocolDescriptor)new ObjectSerializationProtocolDescriptor("java/" + protocolVersion, classLoader));
    }

    protected void addProtocol(ProtocolConfiguration configuration, ProtocolDescriptor protocol) {
        configuration.getProtocols().add(protocol);
    }

    protected void customizeConfiguration(ProtocolConfiguration configuration, boolean clientMode) {
    }

    protected SslContextFactory makeSslContextFactory(boolean clientMode) throws Exception {
        return SslHelper.createDefaultSslFactory((Map)this.connectionInformation.getProperties(), (boolean)clientMode);
    }
}

