/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.ngp;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.server.exporter.ExporterInformation;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.ngp.Exporter;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private static BundleContext context;
    private SingleServiceTracker<Hive> tracker;
    private Exporter exporter;
    private Set<ExporterInformation> exportedInformation;
    private final Collection<ServiceRegistration<ExporterInformation>> registeredExportInformation = new LinkedList<ServiceRegistration<ExporterInformation>>();

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.tracker = new SingleServiceTracker(context, Hive.class, (SingleServiceListener)new SingleServiceListener<Hive>(){

            public void serviceChange(ServiceReference<Hive> reference, Hive service) {
                Activator.this.handleServiceChange(service);
            }
        });
        this.tracker.open();
    }

    protected void handleServiceChange(Hive service) {
        logger.warn("Exporting new service: {}", (Object)service);
        try {
            if (this.exporter != null) {
                this.exporter.stop();
                this.exporter = null;
            }
            this.unregisterAllExportInformations();
            if (service != null) {
                this.exporter = new Exporter(service, ConnectionInformation.fromURI((String)System.getProperty("org.eclipse.scada.da.server.exporter.ngp.exportUri", "da:ngp://0.0.0.0:2101")));
                this.exporter.start();
                this.exportedInformation = this.exporter.getExporterInformation();
                for (ExporterInformation ei : this.exportedInformation) {
                    ServiceRegistration reg = context.registerService(ExporterInformation.class, (Object)ei, null);
                    if (reg == null) continue;
                    this.registeredExportInformation.add((ServiceRegistration<ExporterInformation>)reg);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Failed to export hd service", (Throwable)e);
        }
    }

    private void unregisterAllExportInformations() {
        for (ServiceRegistration<ExporterInformation> reg : this.registeredExportInformation) {
            reg.unregister();
        }
        this.registeredExportInformation.clear();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.unregisterAllExportInformations();
        this.tracker.close();
        if (this.exporter != null) {
            this.exporter.stop();
            this.exporter = null;
        }
        context = null;
    }
}

