/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.scada.core.AttributesHelper;
import org.eclipse.scada.core.InvalidSessionException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.core.server.InvalidItemException;
import org.eclipse.scada.da.core.server.ItemChangeListener;
import org.eclipse.scada.da.core.server.Session;
import org.eclipse.scada.da.server.exporter.common.HiveSource;
import org.eclipse.scada.da.server.exporter.common.HiveSourceListener;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.PropertiesCredentialsCallback;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSubscriptionManager {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSubscriptionManager.class);
    private Hive hive;
    private final Properties properties;
    private Session session;
    private NotifyFuture<Session> createSessionFuture;
    private final Set<String> subscribeList = new HashSet<String>();
    protected final Map<String, DataItemValue> cache = new HashMap<String, DataItemValue>();
    private final ItemChangeListener itemChangeListener = new ItemChangeListener(){

        public void subscriptionChanged(String itemId, SubscriptionState subscriptionState) {
            AbstractSubscriptionManager.this.handleSubscriptionChanged(itemId, subscriptionState);
        }

        public void dataChanged(String itemId, Variant value, Map<String, Variant> attributes, boolean cache) {
            AbstractSubscriptionManager.this.handleDataChanged(itemId, value, attributes, cache);
        }
    };
    protected volatile boolean started = false;
    private final HiveSource hiveSource;
    private final HiveSourceListener hiveListener = new HiveSourceListener(){

        @Override
        public void setHive(Hive hive) {
            AbstractSubscriptionManager.this.performSetHive(hive);
        }
    };

    public AbstractSubscriptionManager(HiveSource hiveSource, Properties properties) {
        this.properties = properties;
        this.hiveSource = hiveSource;
    }

    public synchronized void start() {
        this.hiveSource.addListener(this.hiveListener);
    }

    public synchronized void stop() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.hiveSource.removeListener(this.hiveListener);
        this.unbind();
        this.clearCache();
    }

    protected synchronized void performSetHive(Hive hive) {
        if (this.started) {
            return;
        }
        this.unbind();
        this.clearCache();
        this.bind(hive);
    }

    protected void bind(Hive hive) {
        this.hive = hive;
        if (this.hive != null) {
            logger.info("Creating new session");
            this.createSessionFuture = hive.createSession(this.properties, (CallbackHandler)new PropertiesCredentialsCallback(this.properties));
            this.createSessionFuture.addListener((FutureListener)new FutureListener<Session>(){

                public void complete(Future<Session> future) {
                    AbstractSubscriptionManager.this.handleCreateSessionResult(future);
                }
            });
        }
    }

    protected void unbind() {
        if (this.session != null && this.hive != null) {
            try {
                this.hive.closeSession((org.eclipse.scada.core.server.Session)this.session);
            }
            catch (InvalidSessionException e) {
                logger.warn("Failed to close old session", (Throwable)e);
            }
            this.session = null;
            this.hive = null;
        }
        if (this.createSessionFuture != null) {
            this.createSessionFuture.cancel(true);
            this.createSessionFuture = null;
        }
    }

    protected synchronized void handleCreateSessionResult(Future<Session> future) {
        this.createSessionFuture = null;
        try {
            this.session = future.get();
            this.session.setListener(this.itemChangeListener);
            this.subscribeItems();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("Failed to create hive session", (Throwable)e);
        }
    }

    private void subscribeItems() {
        for (String itemId : this.subscribeList) {
            this.performSubscribe(itemId);
        }
    }

    protected synchronized void subscribe(String itemId) {
        logger.trace("Subscribe to - itemId: {}", (Object)itemId);
        if (this.started) {
            return;
        }
        if (!this.subscribeList.add(itemId)) {
            return;
        }
        if (this.hive == null || this.session == null) {
            return;
        }
        this.performSubscribe(itemId);
    }

    private void performSubscribe(String itemId) {
        try {
            logger.debug("Perform subscribe - itemId: {}", (Object)itemId);
            this.hive.subscribeItem(this.session, itemId);
        }
        catch (InvalidSessionException | InvalidItemException e) {
            this.putState(itemId, new DataItemValue(Variant.NULL, null, SubscriptionState.DISCONNECTED, e));
        }
    }

    protected synchronized void unsubscribe(String itemId) {
        if (this.started) {
            return;
        }
        if (!this.subscribeList.remove(itemId)) {
            return;
        }
        this.putState(itemId, null);
        if (this.hive != null && this.session != null) {
            try {
                this.hive.unsubscribeItem(this.session, itemId);
            }
            catch (InvalidSessionException | InvalidItemException e) {
                logger.warn("Failed to unsubscribe item", e);
            }
        }
    }

    protected void clearCache() {
        this.cache.clear();
    }

    protected void putState(String itemId, DataItemValue value) {
        logger.trace("Cache put - itemId: {}, value: {}", (Object)itemId, (Object)value);
        if (value == null) {
            this.cache.remove(itemId);
        } else {
            this.cache.put(itemId, value);
        }
    }

    public synchronized Map<String, DataItemValue> getCacheCopy() {
        if (this.started) {
            return Collections.emptyMap();
        }
        return new HashMap<String, DataItemValue>(this.cache);
    }

    protected synchronized void handleDataChanged(String itemId, Variant value, Map<String, Variant> attributes, boolean cache) {
        logger.trace("DataChange - itemId: {}, value: {}, attributes: {}, cache: {}", new Object[]{itemId, value, attributes, cache});
        if (!this.subscribeList.contains(itemId) || this.session == null || this.hive == null) {
            return;
        }
        if (cache) {
            this.putState(itemId, new DataItemValue(value, attributes, SubscriptionState.CONNECTED, null));
            return;
        }
        DataItemValue oldState = this.cache.get(itemId);
        if (oldState == null) {
            this.putState(itemId, new DataItemValue(value, attributes, SubscriptionState.CONNECTED, null));
            return;
        }
        DataItemValue.Builder builder = new DataItemValue.Builder(oldState);
        if (value != null) {
            builder.setValue(value);
        }
        if (attributes != null) {
            AttributesHelper.mergeAttributes((Map)builder.getAttributes(), attributes);
        }
        this.putState(itemId, builder.build());
    }

    protected void handleSubscriptionChanged(String itemId, SubscriptionState subscriptionState) {
        if (!this.subscribeList.contains(itemId) || this.session == null || this.hive == null) {
            return;
        }
        DataItemValue oldState = this.cache.get(itemId);
        if (oldState == null) {
            this.putState(itemId, new DataItemValue(Variant.NULL, null, subscriptionState, null));
            return;
        }
        DataItemValue.Builder builder = new DataItemValue.Builder(oldState);
        builder.setSubscriptionState(subscriptionState);
        this.putState(itemId, builder.build());
    }
}

