/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.common;

import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.server.exporter.common.AbstractSubscriptionManager;
import org.eclipse.scada.da.server.exporter.common.HiveSource;

public class AggregatingSubscriptionManager
extends AbstractSubscriptionManager {
    private final Listener listener;
    protected final ScheduledExecutorService executor;

    public AggregatingSubscriptionManager(ScheduledExecutorService executor, HiveSource hiveSource, Properties properties, Listener listener) {
        super(hiveSource, properties);
        this.executor = executor;
        this.listener = listener;
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.notifyStateUpdate(true);
    }

    private void notifyStateUpdate(final boolean ignoreDisposed) {
        if (this.started && !ignoreDisposed) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!AggregatingSubscriptionManager.this.started || ignoreDisposed) {
                    AggregatingSubscriptionManager.this.listener.stateUpdate();
                }
            }
        });
    }

    @Override
    protected void clearCache() {
        super.clearCache();
        this.notifyStateUpdate(false);
    }

    @Override
    protected void putState(String itemId, DataItemValue value) {
        super.putState(itemId, value);
        this.notifyStateUpdate(false);
    }

    @Override
    public synchronized void subscribe(String itemId) {
        super.subscribe(itemId);
    }

    @Override
    public synchronized void unsubscribe(String itemId) {
        super.unsubscribe(itemId);
    }

    public static interface Listener {
        public void stateUpdate();
    }
}

