/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server.common.osgi;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.eclipse.scada.core.InvalidSessionException;
import org.eclipse.scada.core.server.Session;
import org.eclipse.scada.core.server.common.AuthorizationProvider;
import org.eclipse.scada.core.server.common.ServiceCommon;
import org.eclipse.scada.core.server.common.osgi.SessionPrivilegeTracker;
import org.eclipse.scada.core.server.common.session.AbstractSessionImpl;
import org.eclipse.scada.core.server.common.session.PrivilegeListenerImpl;
import org.eclipse.scada.sec.AuthenticationImplementation;
import org.eclipse.scada.sec.AuthorizationImplementation;
import org.eclipse.scada.sec.AuthorizationReply;
import org.eclipse.scada.sec.AuthorizationRequest;
import org.eclipse.scada.sec.AuthorizationResult;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.audit.AuditLogService;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.osgi.AuthorizationTracker;
import org.eclipse.scada.sec.osgi.TrackingAuditLogImplementation;
import org.eclipse.scada.sec.osgi.TrackingAuthenticationImplementation;
import org.eclipse.scada.sec.osgi.TrackingAuthorizationImplementation;
import org.eclipse.scada.sec.osgi.TrackingAuthorizationTracker;
import org.eclipse.scada.utils.concurrent.CallingFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public abstract class AbstractServiceImpl<S extends Session, SI extends AbstractSessionImpl>
extends ServiceCommon<S, SI> {
    private final TrackingAuthorizationImplementation authorizationHelper;
    protected final Set<SI> sessions = new CopyOnWriteArraySet<SI>();
    private final TrackingAuthorizationTracker authorizationTracker;
    private final Executor executor;
    protected final AuthorizationProvider<AbstractSessionImpl> authorizationProvider = new AuthorizationProvider<AbstractSessionImpl>(){

        @Override
        public NotifyFuture<UserInformation> impersonate(AbstractSessionImpl session, String targetUserName, CallbackHandler handler) {
            return AbstractServiceImpl.this.makeEffectiveUserInformation(session, targetUserName, handler);
        }

        @Override
        public NotifyFuture<AuthorizationReply> authorize(AuthorizationRequest authorizationRequest, CallbackHandler handler, AuthorizationResult defaultResult) {
            return AbstractServiceImpl.this.authorize(authorizationRequest, handler, defaultResult);
        }
    };
    private final TrackingAuthenticationImplementation authenticationImplemenation;
    private final TrackingAuditLogImplementation auditLogTracker;

    public AbstractServiceImpl(BundleContext context, Executor executor) throws InvalidSyntaxException {
        this.executor = executor;
        this.authorizationHelper = new TrackingAuthorizationImplementation(context);
        this.authorizationTracker = new TrackingAuthorizationTracker(context);
        this.authenticationImplemenation = new TrackingAuthenticationImplementation(context);
        this.auditLogTracker = new TrackingAuditLogImplementation(context);
        this.setAuthorizationImplementation((AuthorizationImplementation)this.authorizationHelper);
        this.setAuthenticationImplementation((AuthenticationImplementation)this.authenticationImplemenation);
        this.setAuditLogService((AuditLogService)this.auditLogTracker);
    }

    public void start() throws Exception {
        this.authorizationHelper.open();
        this.authorizationTracker.open();
        this.authenticationImplemenation.open();
        this.auditLogTracker.open();
    }

    public void stop() throws Exception {
        for (AbstractSessionImpl session : this.sessions) {
            session.dispose();
        }
        this.auditLogTracker.close();
        this.authenticationImplemenation.close();
        this.authorizationHelper.close();
        this.authorizationTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(S session) throws InvalidSessionException {
        AbstractSessionImpl sessionImpl = null;
        AbstractServiceImpl abstractServiceImpl = this;
        synchronized (abstractServiceImpl) {
            if (this.sessions.remove(session)) {
                sessionImpl = (AbstractSessionImpl)session;
            }
        }
        if (sessionImpl != null) {
            sessionImpl.dispose();
            this.handleSessionClosed(sessionImpl);
        }
    }

    protected void handleSessionClosed(SI session) {
    }

    public NotifyFuture<S> createSession(final Properties properties, final CallbackHandler callbackHandler) {
        NotifyFuture<UserInformation> loginFuture = this.loginUser(properties, callbackHandler);
        return new CallingFuture<UserInformation, S>(loginFuture){

            public S call(Future<UserInformation> future) throws Exception {
                return AbstractServiceImpl.this.createSession(future, properties, callbackHandler);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected S createSession(Future<UserInformation> loginFuture, Properties properties, CallbackHandler callbackHandler) throws Exception {
        SI session;
        UserInformation user = loginFuture.get();
        AbstractServiceImpl abstractServiceImpl = this;
        synchronized (abstractServiceImpl) {
            HashMap<String, String> sessionProperties = new HashMap<String, String>();
            session = this.createSessionInstance(user, sessionProperties);
            Set<String> privileges = this.extractPrivileges(properties);
            final SessionPrivilegeTracker privTracker = new SessionPrivilegeTracker(this.executor, new PrivilegeListenerImpl((AbstractSessionImpl)session), (AuthorizationTracker)this.authorizationTracker, privileges, user);
            ((AbstractSessionImpl)session).addDisposeListener(new AbstractSessionImpl.DisposeListener(){

                @Override
                public void disposed() {
                    privTracker.dispose();
                }
            });
            this.sessions.add(session);
            this.handleSessionCreated(session);
        }
        return (S)session;
    }

    protected void handleSessionCreated(SI session) {
    }

    protected abstract SI createSessionInstance(UserInformation var1, Map<String, String> var2);

    protected synchronized SI validateSession(S session, Class<SI> sessionImplClazz) throws InvalidSessionException {
        if (!this.sessions.contains(session)) {
            throw new InvalidSessionException();
        }
        try {
            return (SI)((AbstractSessionImpl)sessionImplClazz.cast(session));
        }
        catch (ClassCastException classCastException) {
            throw new InvalidSessionException();
        }
    }
}

