/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.storage.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.storage.jdbc.StorageDao;
import org.eclipse.scada.core.VariantType;
import org.eclipse.scada.utils.osgi.jdbc.CommonConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.pool.PoolConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.task.CommonConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionContext;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionTask;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStorageDao
implements StorageDao {
    private static final Logger logger = LoggerFactory.getLogger(BaseStorageDao.class);
    private String schema = "";
    private int maxLength = 4000;
    private String instance = "default";
    protected final CommonConnectionAccessor accessor;

    public BaseStorageDao(DataSourceFactory dataSourceFactory, Properties paramProperties, boolean usePool) throws SQLException {
        this.accessor = usePool ? new PoolConnectionAccessor(dataSourceFactory, paramProperties) : new DataSourceConnectionAccessor(dataSourceFactory, paramProperties);
    }

    @Override
    public void dispose() {
        this.accessor.dispose();
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getInstance() {
        return this.instance;
    }

    public Connection createConnection() throws SQLException {
        Connection connection = this.accessor.getConnection();
        connection.setAutoCommit(false);
        return connection;
    }

    protected CommonConnectionAccessor getAccessor() {
        return this.accessor;
    }

    public void closeStatement(Statement statement) {
        try {
            if (statement == null || statement.isClosed()) {
                return;
            }
            statement.close();
        }
        catch (SQLException e) {
            logger.debug("Exception on closing statement", (Throwable)e);
        }
    }

    public void closeConnection(Connection connection) {
        try {
            if (connection == null || connection.isClosed()) {
                return;
            }
            connection.close();
        }
        catch (SQLException e) {
            logger.debug("Exception on closing statement", (Throwable)e);
        }
    }

    @Override
    public void updateComment(final UUID id, final String comment) throws Exception {
        this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Void>(){

            protected Void performTask(ConnectionContext connectionContext) throws Exception {
                connectionContext.setAutoCommit(false);
                BaseStorageDao.this.performUpdateCommand(id, comment, connectionContext.getConnection());
                return null;
            }
        });
    }

    private void performUpdateCommand(UUID id, String comment, Connection con) throws SQLException {
        PreparedStatement stm1 = con.prepareStatement(String.format(this.getDeleteAttributesSql(), this.getSchema()));
        try {
            stm1.setString(1, id.toString());
            stm1.setString(2, Event.Fields.COMMENT.getName());
            stm1.addBatch();
            stm1.execute();
            PreparedStatement stm2 = con.prepareStatement(String.format(this.getInsertAttributesSql(), this.getSchema()));
            try {
                stm2.setString(1, id.toString());
                stm2.setString(2, Event.Fields.COMMENT.getName());
                stm2.setString(3, VariantType.STRING.name());
                stm2.setString(4, this.clip(this.getMaxLength(), comment));
                stm2.setLong(5, (long)null);
                stm2.setDouble(6, (double)null);
                stm2.addBatch();
                stm2.execute();
                con.commit();
            }
            finally {
                this.closeStatement(stm2);
            }
        }
        finally {
            this.closeStatement(stm1);
        }
    }

    protected String clip(int i, String string) {
        if (string == null) {
            return null;
        }
        if (i < 1 || string.length() <= i) {
            return string;
        }
        return string.substring(0, i);
    }

    protected int getCleanupDays() {
        return Integer.getInteger("org.eclipse.scada.ae.server.storage.jdbc.archiveDays", -1);
    }

    protected abstract String getDeleteAttributesSql();

    protected abstract String getInsertAttributesSql();
}

