/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.memory.Attribute;
import org.eclipse.scada.da.server.common.memory.MemoryRequestBlock;
import org.eclipse.scada.da.server.common.memory.ScalarVariable;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;

public class BitVariable
extends ScalarVariable {
    private final int subIndex;

    public BitVariable(String name, int index, int subIndex, Executor executor, ManageableObjectPool<DataItem> itemPool, Attribute ... attributes) {
        super(name, index, executor, itemPool, attributes);
        this.subIndex = subIndex;
    }

    @Override
    protected Variant extractValue(IoBuffer data, Map<String, Variant> attributes) {
        byte b = data.get(this.toAddress(this.index));
        boolean flag = (b & 1 << this.subIndex) != 0;
        return Variant.valueOf((boolean)flag);
    }

    @Override
    protected NotifyFuture<WriteResult> handleWrite(Variant value) {
        MemoryRequestBlock block = this.block;
        if (block == null) {
            return new InstantErrorFuture(new OperationException("Device not connected").fillInStackTrace());
        }
        block.writeBit(this.toAddress(this.index), this.subIndex, value.asBoolean());
        return new InstantFuture((Object)new WriteResult());
    }
}

