/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.memory.Attribute;
import org.eclipse.scada.da.server.common.memory.MemoryRequestBlock;
import org.eclipse.scada.da.server.common.memory.ScalarVariable;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;

public class DoubleIntegerVariable
extends ScalarVariable {
    public DoubleIntegerVariable(String name, int index, Executor executor, ManageableObjectPool<DataItem> itemPool, Attribute ... attributes) {
        super(name, index, executor, itemPool, attributes);
    }

    @Override
    protected NotifyFuture<WriteResult> handleWrite(Variant value) {
        MemoryRequestBlock block = this.block;
        if (block == null) {
            return new InstantErrorFuture((Throwable)new IllegalStateException("Device is not connected"));
        }
        Integer i = value.asInteger(null);
        if (i != null) {
            ByteBuffer b = ByteBuffer.allocate(4);
            b.putInt(i);
            block.writeData(this.toAddress(this.index), b.array());
            return new InstantFuture((Object)new WriteResult());
        }
        return new InstantErrorFuture((Throwable)new IllegalArgumentException(String.format("Can only write doubles: %s is not a double", value)));
    }

    @Override
    protected Variant extractValue(IoBuffer data, Map<String, Variant> attributes) {
        return Variant.valueOf((int)data.getInt(this.toAddress(this.index)));
    }
}

