/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.memory.AbstractAttribute;
import org.eclipse.scada.da.server.common.memory.Attribute;
import org.eclipse.scada.da.server.common.memory.MemoryRequestBlock;

public class FloatAttribute
extends AbstractAttribute
implements Attribute {
    private final int index;
    private Float lastValue;
    private Variant lastTimestamp;
    private final boolean enableTimestamp;

    public FloatAttribute(String name, int index, boolean enableTimestamp) {
        super(name);
        this.index = index;
        this.enableTimestamp = enableTimestamp;
    }

    @Override
    public void handleData(IoBuffer data, Map<String, Variant> attributes, Variant timestamp) {
        float f = data.getFloat(this.toAddress(this.index));
        attributes.put(this.name, Variant.valueOf((double)f));
        if (!Float.valueOf(f).equals(this.lastValue)) {
            this.lastValue = Float.valueOf(f);
            this.lastTimestamp = timestamp;
        }
        if (this.enableTimestamp) {
            attributes.put(String.valueOf(this.name) + ".timestamp", this.lastTimestamp);
        }
    }

    @Override
    public void handleError(Map<String, Variant> attributes) {
        this.lastValue = null;
        this.lastTimestamp = null;
    }

    @Override
    public void handleWrite(Variant value) {
        MemoryRequestBlock block = this.block;
        if (block == null) {
            throw new IllegalStateException("Device is not connected");
        }
        Double d = value.asDouble(null);
        if (d != null) {
            ByteBuffer b = ByteBuffer.allocate(4);
            b.putFloat(d.floatValue());
            block.writeData(this.toAddress(this.index), b.array());
        }
    }
}

