/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.chain.ChainItem;
import org.eclipse.scada.da.server.common.chain.item.SumAlarmChainItem;
import org.eclipse.scada.da.server.common.chain.item.SumErrorChainItem;
import org.eclipse.scada.da.server.common.chain.item.SumPatternAttributesChainItem;
import org.eclipse.scada.da.server.common.memory.Attribute;
import org.eclipse.scada.da.server.common.memory.MemoryDeviceDataitem;
import org.eclipse.scada.da.server.common.memory.MemoryRequestBlock;
import org.eclipse.scada.da.server.common.memory.Variable;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;
import org.osgi.framework.BundleContext;

public abstract class ScalarVariable
implements Variable {
    private final String name;
    protected final int index;
    private final Executor executor;
    protected MemoryDeviceDataitem item;
    private final Attribute[] attributes;
    private int offset;
    protected MemoryRequestBlock block;
    private final ManageableObjectPool<DataItem> itemPool;

    public ScalarVariable(String name, int index, Executor executor, ManageableObjectPool<DataItem> itemPool, Attribute ... attributes) {
        this.name = name;
        this.index = index;
        this.executor = executor;
        this.attributes = attributes;
        this.itemPool = itemPool;
    }

    @Override
    public void handleError(int errorCode) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        Attribute[] attributeArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            attr.handleError(attributes);
            ++n2;
        }
        attributes.put("device.error", Variant.TRUE);
        attributes.put("device.error.code", Variant.valueOf((int)errorCode));
        this.item.updateData(Variant.NULL, attributes, AttributeMode.SET);
    }

    @Override
    public void handleDisconnect() {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        Attribute[] attributeArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            attr.handleError(attributes);
            ++n2;
        }
        attributes.put("communcation.error", Variant.TRUE);
        MemoryDeviceDataitem item = this.item;
        if (item != null) {
            item.updateData(Variant.NULL, attributes, AttributeMode.SET);
        }
    }

    @Override
    public void handleFailure(Throwable e) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        Attribute[] attributeArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            attr.handleError(attributes);
            ++n2;
        }
        attributes.put("generic.error", Variant.TRUE);
        attributes.put("generic.error.message", Variant.valueOf((Object)e.getMessage()));
        this.item.updateData(Variant.NULL, attributes, AttributeMode.SET);
    }

    @Override
    public void start(String parentName, BundleContext context, MemoryRequestBlock block, int offset) {
        this.offset = offset;
        this.block = block;
        Attribute[] attributeArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            attr.start(block, offset);
            ++n2;
        }
        String itemId = parentName != null ? String.valueOf(parentName) + "." + this.name : this.name;
        this.item = new MemoryDeviceDataitem(itemId, this.executor, this);
        this.item.addChainElement(IODirection.INPUT, (ChainItem)new SumAlarmChainItem());
        this.item.addChainElement(IODirection.INPUT, (ChainItem)new SumErrorChainItem());
        this.item.addChainElement(IODirection.INPUT, (ChainItem)new SumPatternAttributesChainItem("manual", ".*\\.manual\\.active$"));
        this.itemPool.addService(itemId, (Object)this.item, null);
    }

    protected NotifyFuture<WriteResult> handleWrite(Variant value) {
        return new InstantErrorFuture((Throwable)new IllegalStateException("Operation not implemented"));
    }

    @Override
    public void stop(BundleContext context) {
        if (this.item == null) {
            return;
        }
        this.itemPool.removeService(this.item.getInformation().getName(), (Object)this.item);
        Attribute[] attributeArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            attr.stop();
            ++n2;
        }
        this.item = null;
    }

    protected abstract Variant extractValue(IoBuffer var1, Map<String, Variant> var2);

    @Override
    public void handleData(IoBuffer data, Variant timestamp) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        Variant value = this.extractValue(data, attributes);
        Attribute[] attributeArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            attr.handleData(data, attributes, timestamp);
            ++n2;
        }
        attributes.put("globalIndex", Variant.valueOf((int)(this.offset + this.index)));
        this.item.updateData(value, attributes, AttributeMode.SET);
    }

    protected int toAddress(int localAddress) {
        return this.offset + localAddress - this.block.getStartAddress();
    }

    public Map<String, WriteAttributeResult> handleAttributes(Map<String, Variant> requests) {
        HashMap<String, WriteAttributeResult> result = new HashMap<String, WriteAttributeResult>();
        for (Map.Entry<String, Variant> entry : requests.entrySet()) {
            Attribute[] attributeArray = this.attributes;
            int n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attr = attributeArray[n2];
                if (attr.getName().equals(entry.getKey())) {
                    try {
                        attr.handleWrite(entry.getValue());
                        result.put(entry.getKey(), WriteAttributeResult.OK);
                    }
                    catch (Throwable e) {
                        result.put(entry.getKey(), new WriteAttributeResult(e));
                    }
                }
                ++n2;
            }
        }
        return result;
    }
}

