/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.memory;

import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.datasource.base.AbstractDataSource;
import org.eclipse.scada.da.server.common.WriteAttributesHelper;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class MemoryDataSource
extends AbstractDataSource {
    private final Executor executor;
    private final DataItemValue.Builder builder = new DataItemValue.Builder();
    private boolean disposed;

    public MemoryDataSource(Executor executor) {
        this.executor = executor;
        this.builder.setSubscriptionState(SubscriptionState.CONNECTED);
        this.update();
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    public NotifyFuture<WriteAttributeResults> startWriteAttributes(final Map<String, Variant> attributes, OperationParameters operationParameters) {
        FutureTask task = new FutureTask((Callable)new Callable<WriteAttributeResults>(){

            @Override
            public WriteAttributeResults call() throws Exception {
                return MemoryDataSource.this.setAttributes(attributes);
            }
        });
        this.executor.execute((Runnable)task);
        return task;
    }

    public NotifyFuture<WriteResult> startWriteValue(final Variant value, OperationParameters operationParameters) {
        FutureTask task = new FutureTask((Callable)new Callable<WriteResult>(){

            @Override
            public WriteResult call() throws Exception {
                return MemoryDataSource.this.setValue(value);
            }
        });
        this.executor.execute((Runnable)task);
        return task;
    }

    protected synchronized WriteResult setValue(Variant value) {
        if (this.disposed) {
            return new WriteResult(new OperationException("Disposed").fillInStackTrace());
        }
        this.builder.setValue(value);
        this.builder.setTimestamp(Calendar.getInstance());
        this.update();
        return new WriteResult();
    }

    protected synchronized WriteAttributeResults setAttributes(Map<String, Variant> attributes) {
        if (this.disposed) {
            return WriteAttributesHelper.errorUnhandled(null, attributes);
        }
        WriteAttributeResults results = new WriteAttributeResults();
        for (Map.Entry<String, Variant> entry : attributes.entrySet()) {
            results.put((Object)entry.getKey(), (Object)WriteAttributeResult.OK);
            if (entry.getValue() == null) {
                this.builder.getAttributes().remove(entry.getKey());
                continue;
            }
            this.builder.getAttributes().put(entry.getKey(), entry.getValue());
        }
        this.builder.setTimestamp(Calendar.getInstance());
        this.update();
        return results;
    }

    protected void update() {
        this.updateData(this.builder.build());
    }

    public void update(Map<String, String> parameters) throws Exception {
    }

    public synchronized void dispose() {
        this.disposed = true;
    }
}

