/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.ae.BrowserListener;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.data.BrowserEntry;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.server.EventListener;
import org.eclipse.scada.ae.server.MonitorListener;
import org.eclipse.scada.ae.server.Session;
import org.eclipse.scada.ae.server.common.QueryImpl;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.server.common.session.AbstractSessionImpl;
import org.eclipse.scada.sec.UserInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionImpl
extends AbstractSessionImpl
implements Session,
BrowserListener {
    private static final Logger logger = LoggerFactory.getLogger(SessionImpl.class);
    private final EventListener eventListener;
    private final MonitorListener monitorListener;
    private volatile MonitorListener clientMonitorListener;
    private volatile EventListener clientEventListener;
    private volatile BrowserListener clientBrowserListener;
    private final Map<String, BrowserEntry> browserCache = new HashMap<String, BrowserEntry>();
    private boolean disposed = false;
    private final Set<QueryImpl> queries = new HashSet<QueryImpl>();

    public SessionImpl(UserInformation userInformation, Map<String, String> properties) {
        super(userInformation, properties);
        logger.info("Created new session");
        this.eventListener = new EventListener(){

            public void dataChanged(String poolId, List<Event> addedEvents) {
                SessionImpl.this.eventDataChanged(poolId, addedEvents);
            }

            public void updateStatus(Object poolId, SubscriptionState state) {
                SessionImpl.this.eventStatusChanged(poolId.toString(), state);
            }
        };
        this.monitorListener = new MonitorListener(){

            public void dataChanged(String subscriptionId, List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
                SessionImpl.this.monitorDataChanged(subscriptionId, addedOrUpdated, removed, full);
            }

            public void updateStatus(Object poolId, SubscriptionState state) {
                SessionImpl.this.monitorStatusChanged(poolId.toString(), state);
            }
        };
    }

    protected void monitorStatusChanged(String string, SubscriptionState state) {
        MonitorListener listener = this.clientMonitorListener;
        if (listener != null) {
            listener.updateStatus((Object)string, state);
        }
    }

    protected void monitorDataChanged(String subscriptionId, List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
        MonitorListener listener = this.clientMonitorListener;
        if (listener != null) {
            logger.info(String.format("Monitor Data Change: %s - %s - %s", subscriptionId, addedOrUpdated != null ? Integer.valueOf(addedOrUpdated.size()) : "none", removed != null ? Integer.valueOf(removed.size()) : "none"));
            listener.dataChanged(subscriptionId, addedOrUpdated, removed, full);
        }
    }

    protected void eventStatusChanged(String string, SubscriptionState state) {
        EventListener listener = this.clientEventListener;
        if (listener != null) {
            listener.updateStatus((Object)string, state);
        }
    }

    protected void eventDataChanged(String poolId, List<Event> addedEvents) {
        EventListener listener = this.clientEventListener;
        if (listener != null) {
            listener.dataChanged(poolId, this.translateEvents(addedEvents));
        }
    }

    protected List<Event> translateEvents(List<Event> events) {
        return events;
    }

    public void setMonitorListener(MonitorListener listener) {
        this.clientMonitorListener = listener;
    }

    public void setEventListener(EventListener listener) {
        this.clientEventListener = listener;
    }

    public synchronized void dispose() {
        logger.info("Disposing session");
        this.disposed = true;
        for (QueryImpl query : new ArrayList<QueryImpl>(this.queries)) {
            query.dispose(null);
        }
        this.queries.clear();
        this.clientMonitorListener = null;
        this.clientEventListener = null;
        this.clientBrowserListener = null;
    }

    public MonitorListener getMonitorListener() {
        return this.monitorListener;
    }

    public EventListener getEventListener() {
        return this.eventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrowserListener(BrowserListener listener) {
        Map<String, BrowserEntry> map = this.browserCache;
        synchronized (map) {
            this.clientBrowserListener = listener;
            if (this.clientBrowserListener != null) {
                this.clientBrowserListener.dataChanged(new ArrayList<BrowserEntry>(this.browserCache.values()), null, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataChanged(List<BrowserEntry> addedOrUpdated, Set<String> removed, boolean full) {
        Map<String, BrowserEntry> map = this.browserCache;
        synchronized (map) {
            BrowserListener listener;
            if (full) {
                this.browserCache.clear();
            }
            if (removed != null) {
                for (String id : removed) {
                    this.browserCache.remove(id);
                }
            }
            if (addedOrUpdated != null) {
                for (BrowserEntry entry : addedOrUpdated) {
                    this.browserCache.put(entry.getId(), entry);
                }
            }
            if ((listener = this.clientBrowserListener) != null) {
                listener.dataChanged(addedOrUpdated, removed, full);
            }
        }
    }

    public synchronized void addQuery(QueryImpl query) {
        if (this.disposed) {
            query.dispose(null);
        } else {
            this.queries.add(query);
        }
    }

    public synchronized void removeQuery(QueryImpl query) {
        this.queries.remove(query);
    }
}

