/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.common.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.EventListener;
import org.eclipse.scada.ae.server.common.event.EventQuery;
import org.eclipse.scada.core.subscription.SubscriptionInformation;
import org.eclipse.scada.core.subscription.SubscriptionSource;
import org.eclipse.scada.utils.collection.BoundedPriorityQueueSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventQuerySource
implements SubscriptionSource,
org.eclipse.scada.ae.event.EventListener {
    private static final Logger logger = LoggerFactory.getLogger(EventQuerySource.class);
    private final String id;
    private final EventQuery eventQuery;
    private final Set<EventListener> listeners = new HashSet<EventListener>();
    private final Queue<Event> cachedData;

    public EventQuerySource(String id, EventQuery query) {
        this.id = id;
        this.eventQuery = query;
        this.cachedData = new BoundedPriorityQueueSet(query.getCapacity(), (Comparator)new Comparator<Event>(){

            @Override
            public int compare(Event o1, Event o2) {
                return Event.comparator.compare(o2, o1);
            }
        });
    }

    public synchronized void addListener(Collection<SubscriptionInformation> listeners) {
        boolean wasEmpty = this.listeners.isEmpty();
        for (SubscriptionInformation information : listeners) {
            EventListener listener = (EventListener)information.getListener();
            this.listeners.add(listener);
            if (this.cachedData.isEmpty()) continue;
            listener.dataChanged(this.id, new ArrayList<Event>(this.cachedData));
        }
        if (wasEmpty && !this.listeners.isEmpty()) {
            this.eventQuery.addListener(this);
        }
    }

    public synchronized void removeListener(Collection<SubscriptionInformation> listeners) {
        for (SubscriptionInformation information : listeners) {
            EventListener listener = (EventListener)information.getListener();
            this.listeners.remove(listener);
        }
        if (this.listeners.isEmpty()) {
            this.eventQuery.removeListener(this);
            this.cachedData.clear();
        }
    }

    public boolean supportsListener(SubscriptionInformation information) {
        return information.getListener() instanceof EventListener;
    }

    public synchronized void handleEvent(List<Event> event) {
        this.cachedData.addAll(event);
        for (EventListener listener : this.listeners) {
            try {
                listener.dataChanged(this.id, event);
            }
            catch (Throwable e) {
                logger.warn("Failed to notify", e);
            }
        }
    }
}

