/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.test;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.browser.common.query.GroupFolder;
import org.eclipse.scada.da.server.browser.common.query.GroupProvider;
import org.eclipse.scada.da.server.browser.common.query.IDNameProvider;
import org.eclipse.scada.da.server.browser.common.query.ItemDescriptor;
import org.eclipse.scada.da.server.browser.common.query.Matcher;
import org.eclipse.scada.da.server.browser.common.query.NameProvider;
import org.eclipse.scada.da.server.browser.common.query.NullNameProvider;
import org.eclipse.scada.da.server.browser.common.query.QueryFolder;
import org.eclipse.scada.da.server.browser.common.query.StorageBasedFolder;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.MemoryDataItem;
import org.eclipse.scada.da.server.common.exporter.ObjectExporter;
import org.eclipse.scada.da.server.common.factory.DataItemValidator;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.common.item.factory.FolderItemFactory;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;
import org.eclipse.scada.da.server.test.items.FactoryMemoryCell;
import org.eclipse.scada.da.server.test.items.MemoryCellItem;
import org.eclipse.scada.da.server.test.items.MemoryChainedItem;
import org.eclipse.scada.da.server.test.items.SuspendItem;
import org.eclipse.scada.da.server.test.items.TestItem1;
import org.eclipse.scada.da.server.test.items.TestItem2;
import org.eclipse.scada.da.server.test.items.TimeDataItem;
import org.eclipse.scada.da.server.test.items.WriteDelayItem;
import org.eclipse.scada.da.server.test.model.TestModelObject;
import org.eclipse.scada.utils.collection.MapBuilder;

public class Hive
extends HiveCommon {
    private final List<ItemDescriptor> changingItems = new LinkedList<ItemDescriptor>();
    private final QueryFolder queryFolderFactory;
    private final List<DataItem> transientItems = new LinkedList<DataItem>();
    private final FolderCommon testFolder;
    private FolderItemFactory itemFactory;
    private final Timer timer = new Timer(true);
    private ObjectExporter objectExporter;
    private TestModelObject testObject;

    public Hive() throws IOException {
        FolderCommon rootFolder = new FolderCommon();
        this.setRootFolder((Folder)rootFolder);
        this.testFolder = new FolderCommon();
        rootFolder.add("test", (Folder)this.testFolder, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"This folder contains numerous test data items!")).getMap());
        FolderCommon helloWorldFolder = new FolderCommon();
        rootFolder.add("Hello World!", (Folder)helloWorldFolder, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"This folder hello world items! Actually there are several tree entries that point to one item instance!")).getMap());
        final QueryFolder queryFolderRoot = new QueryFolder(new Matcher(){

            public boolean matches(ItemDescriptor desc) {
                return true;
            }
        }, (NameProvider)new NullNameProvider());
        QueryFolder queryFolder1 = new QueryFolder(new Matcher(){

            public boolean matches(ItemDescriptor desc) {
                return desc.getItem().getInformation().getName().matches(".*e+.*");
            }
        }, (NameProvider)new IDNameProvider());
        queryFolderRoot.addChild("query", (StorageBasedFolder)queryFolder1, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"contains items the have an 'e' in their id")).getMap());
        this.testFolder.add("storage", (Folder)queryFolderRoot, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"storage based folder for grouping and query folders")).getMap());
        this.queryFolderFactory = new QueryFolder(new Matcher(){

            public boolean matches(ItemDescriptor desc) {
                return desc.getItem().getInformation().getName().matches("memory\\.[a-z0-9]+");
            }
        }, (NameProvider)new IDNameProvider());
        this.testFolder.add("memory-factory", (Folder)this.queryFolderFactory, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"storage folder for items automatically created by the memory cell factory")).getMap());
        GroupFolder groupFolder = new GroupFolder(new GroupProvider(){

            public String[] getGrouping(ItemDescriptor descriptor) {
                String id = descriptor.getItem().getInformation().getName();
                if (id.length() >= 2) {
                    return new String[]{String.valueOf(id.charAt(0)), String.valueOf(id.charAt(1))};
                }
                return null;
            }
        }, (NameProvider)new IDNameProvider());
        queryFolderRoot.addChild("grouping1", (StorageBasedFolder)groupFolder, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"Items with an ID of lenght >=2 will be pre-grouped by their first two characters")).getMap());
        MapBuilder builder = new MapBuilder();
        Object item = new MemoryDataItem("memory");
        this.registerItem((DataItem)item);
        this.testFolder.add("memory", (DataItem)item, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"A memory cell that simply maps the output to its input.")).getMap());
        item = new TestItem2(this, "memory-chained");
        this.registerItem((DataItem)item);
        this.testFolder.add("memory-chained", (DataItem)item, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"A memory cell that simply maps the output to its input using a chain.")).getMap());
        item = new TestItem1("test-1");
        this.registerItem((DataItem)item);
        this.testFolder.add("test-1", (DataItem)item, new MapBuilder().getMap());
        DataItemCommand cmd = new DataItemCommand("hello", this.getOperationService());
        cmd.addListener(new DataItemCommand.Listener(){

            public void command(Variant value) {
                System.out.println("Hello World!");
            }
        });
        item = cmd;
        this.registerItem((DataItem)item);
        helloWorldFolder.add("hello world", (DataItem)item, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"This cell triggers a command on the server. On the server it will print out 'Hello World'. On the client side you will see nothing ;-)")).put((Object)"lang", (Object)Variant.valueOf((Object)"en")).getMap());
        helloWorldFolder.add("\u304a\u306f\u3088\u3046", (DataItem)item, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"This cell triggers a command on the server. On the server it will print out 'Hello World'. On the client side you will see nothing ;-)")).put((Object)"lang", (Object)Variant.valueOf((Object)"ja")).getMap());
        helloWorldFolder.add("\u4f60\u597d", (DataItem)item, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"This cell triggers a command on the server. On the server it will print out 'Hello World'. On the client side you will see nothing ;-)")).put((Object)"lang", (Object)Variant.valueOf((Object)"zh")).getMap());
        helloWorldFolder.add("\u0928\u092e\u0938\u094d\u0924\u0947", (DataItem)item, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"This cell triggers a command on the server. On the server it will print out 'Hello World'. On the client side you will see nothing ;-)")).put((Object)"lang", (Object)Variant.valueOf((Object)"hi")).getMap());
        helloWorldFolder.add("Hallo Welt!", (DataItem)item, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"This cell triggers a command on the server. On the server it will print out 'Hello World'. On the client side you will see nothing ;-)")).put((Object)"lang", (Object)Variant.valueOf((Object)"de")).getMap());
        cmd = new DataItemCommand("command", this.getOperationService());
        cmd.addListener(new DataItemCommand.Listener(){

            public void command(Variant value) {
                System.out.println("Command is: " + value.asString("<null>"));
            }
        });
        item = cmd;
        this.registerItem((DataItem)item);
        this.testFolder.add("command", (DataItem)item, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"Like the 'hello world' item it will print out something on the server. Instead of using a fixed string the value that was written to it is used.")).getMap());
        item = new TimeDataItem("time", this.timer);
        this.registerItem((DataItem)item);
        builder.clear();
        builder.put((Object)"description", (Object)Variant.valueOf((Object)"Need the unix time in microseconds? You get it here!"));
        this.testFolder.add("time", (DataItem)item, builder.getMap());
        this.changingItems.add(new ItemDescriptor((DataItem)item, builder.getMap()));
        this.testFolder.add(String.valueOf(System.currentTimeMillis()), (DataItem)item, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"Alias to 'time' but with a name that will change every server startup.")).getMap());
        MemoryChainedItem memoryChainedItem = new MemoryChainedItem(this, "chained");
        this.registerItem((DataItem)memoryChainedItem);
        this.testFolder.add("chained", (DataItem)memoryChainedItem, new MapBuilder().getMap());
        item = new WriteDelayItem("write-delay", this.getOperationService());
        this.registerItem((DataItem)item);
        this.testFolder.add("write delay", (DataItem)item, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"Simulate a long running write operation here. The value written to the data item is used as microsecond delay that the write operation will take.")).getMap());
        item = new SuspendItem("suspendable");
        this.registerItem((DataItem)item);
        builder.clear();
        builder.put((Object)"description", (Object)Variant.valueOf((Object)"This item is suspendable and will print is suspend status when it changes. WriteAttributeResult can only be seen on the server itself."));
        this.testFolder.add("suspendable", (DataItem)item, builder.getMap());
        this.changingItems.add(new ItemDescriptor((DataItem)item, builder.getMap()));
        FolderCommon memoryFolder = new FolderCommon();
        rootFolder.add("memory-cell", (Folder)memoryFolder, new HashMap());
        item = new MemoryCellItem(this, "memory-cell", memoryFolder);
        this.registerItem((DataItem)item);
        memoryFolder.add("control", (DataItem)item, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"This is the control item of the data cell. Write to number of cells you want to this item. The memory cells wil be created dynamically.")).getMap());
        this.addDataItemValidator(new DataItemValidator(){

            public boolean isValid(String itemId) {
                return itemId.matches("memory-cell-[0-9]+");
            }
        });
        Thread changeThread = new Thread(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                while (true) lbl-1000:
                // 4 sources

                {
                    for (ItemDescriptor desc : Hive.access$0(Hive.this)) {
                        queryFolderRoot.added(desc);
                    }
                    Hive.this.addTransientItems();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    for (ItemDescriptor desc : Hive.access$0(Hive.this)) {
                        queryFolderRoot.removed(desc);
                    }
                    Hive.this.removeTransientItems();
                    try {
                        Thread.sleep(5000L);
                        ** continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        changeThread.setDaemon(true);
        changeThread.start();
        this.setupExporter(rootFolder);
    }

    public String getHiveId() {
        return "org.eclipse.scada.da.server.test";
    }

    private void setupExporter(FolderCommon rootFolder) {
        this.objectExporter = new ObjectExporter((ItemFactory)new FolderItemFactory((HiveCommon)this, rootFolder, "objectExporter", "objectExporter"));
        this.testObject = new TestModelObject();
        this.objectExporter.attachTarget((Object)this.testObject);
        this.testObject.setLongValue(1234L);
    }

    public void addMemoryFactoryItem(FactoryMemoryCell item, Map<String, Variant> browserAttributes) {
        ItemDescriptor desc = new ItemDescriptor((DataItem)item, browserAttributes);
        this.queryFolderFactory.added(desc);
        this.registerItem((DataItem)item);
    }

    public void removeMemoryFactoryItem(FactoryMemoryCell item) {
        this.unregisterItem((DataItem)item);
        this.queryFolderFactory.removeAllForItem((DataItem)item);
    }

    protected void addTransientItems() {
        Object transientItem = new FactoryMemoryCell(this, "transient-memory-cell-1");
        this.registerItem((DataItem)transientItem);
        this.testFolder.add("transient", (DataItem)transientItem, new HashMap());
        this.transientItems.add((DataItem)transientItem);
        transientItem = new TimeDataItem("transient-time", this.timer);
        this.registerItem((DataItem)transientItem);
        this.testFolder.add("transient-time", (DataItem)transientItem, new HashMap());
        this.transientItems.add((DataItem)transientItem);
    }

    protected void removeTransientItems() {
        for (DataItem transientItem : this.transientItems) {
            this.testFolder.remove(transientItem);
            this.unregisterItem(transientItem);
            Object var1_2 = null;
        }
        this.transientItems.clear();
    }

    static /* synthetic */ List access$0(Hive hive) {
        return hive.changingItems;
    }
}

