/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.storage.common;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class RunningAverage {
    private long firstTimestamp;
    private double lastValue = Double.NaN;
    private long lastTimestamp;
    private final MathContext mathContext = new MathContext(10, RoundingMode.HALF_DOWN);
    private BigDecimal M2 = BigDecimal.ZERO;
    private BigDecimal mean = BigDecimal.ZERO;
    private long sumWeight = 0L;
    private long numOfIncrements = 0L;
    private boolean hadValue = false;

    public void next(double value, long timestamp) {
        this.increment(timestamp);
        this.hadValue = this.hadValue || !Double.isNaN(this.lastValue);
        this.lastValue = value;
        this.lastTimestamp = timestamp;
    }

    private void increment(long timestamp) {
        long offset = timestamp - this.lastTimestamp;
        long newSumWeight = offset + this.sumWeight;
        if (offset > 0L && !Double.isNaN(this.lastValue)) {
            BigDecimal delta = BigDecimal.valueOf(this.lastValue).subtract(this.mean);
            BigDecimal R = delta.multiply(BigDecimal.valueOf(offset)).divide(BigDecimal.valueOf(newSumWeight), this.mathContext);
            this.mean = this.mean.add(R);
            this.M2 = this.M2.add(BigDecimal.valueOf(this.sumWeight).multiply(delta).multiply(R));
            this.hadValue = true;
            this.sumWeight = newSumWeight;
            ++this.numOfIncrements;
        }
    }

    public void step(long timestamp) {
        this.firstTimestamp = timestamp;
        this.lastTimestamp = timestamp;
        this.M2 = BigDecimal.ZERO;
        this.mean = BigDecimal.ZERO;
        this.sumWeight = 0L;
        this.numOfIncrements = 0L;
        this.hadValue = false;
    }

    public double getAverage(long lastTimestamp) {
        this.increment(lastTimestamp);
        if (lastTimestamp == this.firstTimestamp || !this.hadValue) {
            return Double.NaN;
        }
        return this.mean.doubleValue();
    }

    public double getDeviation(long lastTimestamp) {
        this.increment(lastTimestamp);
        if (lastTimestamp == this.firstTimestamp || !this.hadValue) {
            return Double.NaN;
        }
        if (this.numOfIncrements < 2L) {
            return 0.0;
        }
        BigDecimal variance_n = this.M2.divide(BigDecimal.valueOf(this.sumWeight), this.mathContext);
        BigDecimal variance = variance_n.multiply(BigDecimal.valueOf(this.numOfIncrements).divide(BigDecimal.valueOf(this.numOfIncrements - 1L), this.mathContext));
        return Math.sqrt(variance.doubleValue());
    }
}

