/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.importer.hsdb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.hd.server.importer.hsdb.HSDBItemController;
import org.eclipse.scada.hd.server.importer.hsdb.HSDBValueSource;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSDBStorageManager {
    private static final Logger logger = LoggerFactory.getLogger(HSDBStorageManager.class);
    private final File root;
    private final BundleContext context;
    private final Set<HSDBItemController> sources = new CopyOnWriteArraySet<HSDBItemController>();
    private final String prefix;
    private final ScheduledExecutorService executor;

    public HSDBStorageManager(ScheduledExecutorService executor, String prefix, BundleContext bundleContext, File root) {
        this.executor = executor;
        this.prefix = prefix;
        this.root = root;
        this.context = bundleContext;
        this.scan();
    }

    private void scan() {
        if (!this.root.isDirectory()) {
            logger.warn("{} is not a directory. Skipping scan!", (Object)this.root);
            return;
        }
        logger.info("Scanning {} for sources...", (Object)this.root);
        File[] fileArray = this.root.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                String baseName;
                logger.debug("Entry: {}", (Object)file);
                if (file.isDirectory() && new File(file, String.valueOf(baseName = file.getName()) + ".va_ctrl").canRead()) {
                    this.createSource(file);
                }
            }
            catch (Exception e) {
                logger.warn("Failed scanning source: " + file, (Throwable)e);
            }
            ++n2;
        }
    }

    private void createSource(File file) throws FileNotFoundException, IOException {
        logger.info("Importing {} ...", (Object)file);
        Properties p = new Properties();
        p.load(new FileInputStream(new File(file, String.valueOf(file.getName()) + ".va_ctrl")));
        String id = p.getProperty("hsdb.manager.configurationId");
        String dataType = p.getProperty("hsdb.dataType");
        if (id == null) {
            return;
        }
        if (!dataType.equals("DOUBLE")) {
            logger.warn("Data type {} is not supported", (Object)dataType);
            return;
        }
        logger.info("Importing as {} -> {}", (Object)id, (Object)(String.valueOf(this.prefix) + id));
        HSDBValueSource source = new HSDBValueSource(this.context, file, file.getName());
        HSDBItemController item = new HSDBItemController(id, this.executor, this.context, source);
        this.sources.add(item);
    }

    public void dispose() {
        for (HSDBItemController source : this.sources) {
            source.dispose();
        }
        this.sources.clear();
    }
}

