/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.modbus.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.server.exporter.common.HiveSource;
import org.eclipse.scada.da.server.exporter.common.SingleSubscriptionManager;
import org.eclipse.scada.da.server.exporter.modbus.io.SourceDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryBlock {
    private static final Logger logger = LoggerFactory.getLogger(MemoryBlock.class);
    private final SingleSubscriptionManager manager;
    private final Map<SourceDefinition, SingleSubscriptionManager.Listener> definitions = new HashMap<SourceDefinition, SingleSubscriptionManager.Listener>();
    private IoBuffer buffer = IoBuffer.allocate((int)0);
    private final Lock readLock;
    private final Lock writeLock;

    public MemoryBlock(ScheduledExecutorService executor, HiveSource hiveSource, Properties properties) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.manager = new SingleSubscriptionManager(executor, hiveSource, properties);
        this.manager.start();
    }

    public void dispose() {
        this.writeLock.lock();
        try {
            this.manager.stop();
            this.buffer = IoBuffer.allocate((int)0);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public IoBuffer readData(int offset, int length) {
        this.readLock.lock();
        try {
            IoBuffer ioBuffer = this.performRead(offset, length);
            return ioBuffer;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private IoBuffer performRead(int offset, int length) {
        logger.debug("Perform read - offset: {}, length: {}, capacity: {}", new Object[]{offset, length, this.buffer.capacity()});
        if (length == 0) {
            return null;
        }
        if (offset < 0) {
            return null;
        }
        if (offset + length > this.buffer.capacity()) {
            return null;
        }
        IoBuffer result = IoBuffer.allocate((int)length);
        result.put(this.buffer.getSlice(offset, length));
        return result;
    }

    public void setConfiguration(List<SourceDefinition> definitions) {
        this.writeLock.lock();
        try {
            SingleSubscriptionManager.Listener listener;
            logger.debug("Setting definitions: {}", definitions);
            logger.debug("Current definitions: {}", this.definitions);
            ArrayList<SourceDefinition> newDefs = new ArrayList<SourceDefinition>(definitions);
            newDefs.removeAll(this.definitions.values());
            ArrayList<SourceDefinition> oldDefs = new ArrayList<SourceDefinition>(this.definitions.keySet());
            oldDefs.removeAll(definitions);
            logger.debug("Remove definitions: {}", oldDefs);
            logger.debug("Add definitions: {}", newDefs);
            for (final SourceDefinition def : oldDefs) {
                logger.debug("Remove: {}", (Object)def);
                listener = this.definitions.remove(def);
                this.manager.removeListener(def.getItemId(), listener);
            }
            for (final SourceDefinition def : newDefs) {
                logger.debug("Add: {}", (Object)def);
                listener = new SingleSubscriptionManager.Listener(){

                    public void stateChanged(String itemId, DataItemValue value) {
                        logger.trace("stateChanged - itemId: {}, value: {}, definition: {}", new Object[]{itemId, value, def});
                        MemoryBlock.this.handleStateChange(def, value);
                    }
                };
                this.manager.addListener(def.getItemId(), listener);
                this.definitions.put(def, listener);
            }
            Map cache = this.manager.getCacheCopy();
            if (!definitions.isEmpty()) {
                int maxOffset = -1;
                int maxOffsetLength = 0;
                for (SourceDefinition def : definitions) {
                    if (def.getOffset() <= maxOffset) continue;
                    maxOffset = def.getOffset();
                    maxOffsetLength = def.getType().getLength();
                }
                IoBuffer buffer = IoBuffer.allocate((int)(maxOffset + maxOffsetLength));
                buffer.setAutoExpand(false);
                logger.debug("Buffer: {}", (Object)buffer);
                logger.debug("Limit: {}", (Object)buffer.limit());
                for (SourceDefinition def : definitions) {
                    DataItemValue value = (DataItemValue)cache.get(def.getItemId());
                    logger.trace("Render value - def: {}, value: {}", (Object)def, (Object)value);
                    def.getType().render(buffer, def.getOffset(), value);
                }
                this.buffer = buffer;
            } else {
                this.buffer = IoBuffer.allocate((int)0);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void handleStateChange(SourceDefinition definition, DataItemValue value) {
        logger.trace("Value change - definition: {}, value: {}", (Object)definition, (Object)value);
        this.writeLock.lock();
        try {
            definition.getType().render(this.buffer, definition.getOffset(), value);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

