/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.http;

import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.servlet.Servlet;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.MonitorService;
import org.eclipse.scada.ae.server.common.akn.AknHandler;
import org.eclipse.scada.ae.server.http.filter.EventFilter;
import org.eclipse.scada.ae.server.http.filter.EventFilterImpl;
import org.eclipse.scada.ae.server.http.internal.JsonServlet;
import org.eclipse.scada.ae.server.http.monitor.EventMonitorFactory;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private static final String SERVLET_PATH = "/org.eclipse.scada.ae";
    private BundleContext context;
    private ExecutorService executor;
    private EventProcessor eventProcessor;
    private ServiceTracker<HttpService, HttpService> httpServiceTracker;
    private HttpService httpService;
    private ServiceRegistration<?> factoryServiceHandle;
    private EventMonitorFactory factory;
    private ObjectPoolImpl<MonitorService> monitorServicePool;
    private ServiceRegistration<?> monitorServicePoolHandler;
    private EventFilter eventFilter;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(context.getBundle().getSymbolicName()));
        this.eventProcessor = new EventProcessor(context);
        this.eventFilter = new EventFilterImpl(context, String.valueOf(context.getBundle().getSymbolicName()) + ".eventFilter");
        this.monitorServicePool = new ObjectPoolImpl();
        this.monitorServicePoolHandler = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.monitorServicePool, MonitorService.class);
        this.httpServiceTracker = new ServiceTracker(context, HttpService.class, this.createHttpServiceTrackerCustomizer());
        this.eventProcessor.open();
        this.factory = new EventMonitorFactory(this.context, this.executor, this.monitorServicePool, this.eventProcessor);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("factoryId", "ae.monitor.ae.event.external");
        properties.put("service.description", "Filter based http event monitor");
        this.factoryServiceHandle = this.context.registerService(new String[]{ConfigurationFactory.class.getName(), AknHandler.class.getName()}, (Object)this.factory, properties);
        this.httpServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.httpServiceTracker.close();
        if (this.factoryServiceHandle != null) {
            this.factoryServiceHandle.unregister();
        }
        if (this.factory != null) {
            this.factory.dispose();
        }
        this.eventProcessor.close();
        this.monitorServicePoolHandler.unregister();
        this.monitorServicePool.dispose();
        this.executor.shutdown();
        this.eventFilter.dispose();
        this.context = null;
    }

    private void bind() {
        if (this.httpService == null) {
            return;
        }
        try {
            this.httpService.registerServlet(SERVLET_PATH, (Servlet)new JsonServlet(this.eventProcessor, this.factory, this.eventFilter), null, null);
            this.httpService.registerResources("/org.eclipse.scada.ae/ui", "/ui", null);
        }
        catch (Exception e) {
            logger.error("Failed to bind", (Throwable)e);
        }
    }

    private void unbind() {
        if (this.httpService != null) {
            this.httpService.unregister("/org.eclipse.scada.ae/ui");
            this.httpService.unregister(SERVLET_PATH);
        }
    }

    private ServiceTrackerCustomizer<HttpService, HttpService> createHttpServiceTrackerCustomizer() {
        return new ServiceTrackerCustomizer<HttpService, HttpService>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public HttpService addingService(ServiceReference<HttpService> reference) {
                HttpService service = (HttpService)Activator.this.context.getService(reference);
                Activator activator = Activator.this;
                synchronized (activator) {
                    if (Activator.this.httpService == null) {
                        Activator.this.httpService = service;
                        Activator.this.bind();
                    }
                }
                return service;
            }

            public void modifiedService(ServiceReference<HttpService> reference, HttpService service) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference<HttpService> reference, HttpService service) {
                Activator activator = Activator.this;
                synchronized (activator) {
                    if (service != Activator.this.httpService) {
                        return;
                    }
                    Activator.this.unbind();
                    Activator.this.httpService = null;
                    Activator.this.context.ungetService(reference);
                }
            }
        };
    }
}

