/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.console;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.scada.ca.Configuration;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.ca.Factory;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.str.Tables;

public class Console {
    private ConfigurationAdministrator admin;

    public void setAdmin(ConfigurationAdministrator admin) {
        this.admin = admin;
    }

    @Descriptor(value="Delete all elements from the factory")
    public void purge(@Descriptor(value="The factory id") String factoryId) {
        NotifyFuture future = this.admin.purgeFactory(null, factoryId);
        future.addListener((FutureListener)new FutureListener<Void>(){

            public void complete(Future<Void> future) {
                System.out.println("Purge completed");
                try {
                    future.get();
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
        });
    }

    @Descriptor(value="Delete an existing configuration")
    public void delete(@Descriptor(value="The factory id") String factoryId, @Descriptor(value="The configuration id") String configurationId) {
        NotifyFuture future = this.admin.deleteConfiguration(null, factoryId, configurationId);
        future.addListener((FutureListener)new CommonResultPrinter(System.out, String.format("delete - %s/%s", factoryId, configurationId)));
    }

    @Descriptor(value="Create a new configuration")
    public void create(@Descriptor(value="The factory id") String factoryId, @Descriptor(value="The configuration id") String configurationId, @Descriptor(value="The configuration data in key=value format") String[] data) {
        NotifyFuture future = this.admin.createConfiguration(null, factoryId, configurationId, this.parse(data));
        future.addListener((FutureListener)new CommonResultPrinter(System.out, String.format("create - %s/%s", factoryId, configurationId)));
    }

    @Descriptor(value="Make a delta update to the configuration")
    public void update(@Descriptor(value="The factory id") String factoryId, @Descriptor(value="The configuration id") String configurationId, @Descriptor(value="The configuration data in key=value format") String[] data) {
        NotifyFuture future = this.admin.updateConfiguration(null, factoryId, configurationId, this.parse(data), false);
        future.addListener((FutureListener)new CommonResultPrinter(System.out, String.format("update - %s/%s", factoryId, configurationId)));
    }

    @Descriptor(value="Make a full update to the configuration")
    public void set(@Descriptor(value="The factory id") String factoryId, @Descriptor(value="The configuration id") String configurationId, @Descriptor(value="The configuration data in key=value format") String[] data) {
        NotifyFuture future = this.admin.updateConfiguration(null, factoryId, configurationId, this.parse(data), true);
        future.addListener((FutureListener)new CommonResultPrinter(System.out, String.format("set - %s/%s", factoryId, configurationId)));
    }

    @Descriptor(value="Show full factories information")
    public void showfactories() {
        LinkedList data = new LinkedList();
        Factory[] factoryArray = this.admin.getKnownFactories();
        int n = factoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Factory factory = factoryArray[n2];
            LinkedList<String> row = new LinkedList<String>();
            row.add(factory.getId());
            row.add(factory.getState().toString());
            row.add(factory.getDescription());
            data.add(row);
            ++n2;
        }
        Tables.showTable((PrintStream)System.out, Arrays.asList("ID", "State", "Description"), data, (int)2);
    }

    @Descriptor(value="Enumerate factory IDs")
    public void factories() {
        Factory[] factoryArray = this.admin.getKnownFactories();
        int n = factoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Factory factory = factoryArray[n2];
            System.out.println(factory.getId());
            ++n2;
        }
    }

    @Descriptor(value="List content of a factory")
    public void listfactory(@Descriptor(value="The factory id") String factoryId) {
        Configuration[] cfgs = this.admin.getConfigurations(factoryId);
        LinkedList rows = new LinkedList();
        if (cfgs != null) {
            Configuration[] configurationArray = cfgs;
            int n = cfgs.length;
            int n2 = 0;
            while (n2 < n) {
                Configuration cfg = configurationArray[n2];
                LinkedList<String> row = new LinkedList<String>();
                row.add(cfg.getId());
                row.add(cfg.getState().toString());
                if (cfg.getErrorInformation() != null) {
                    row.add(cfg.getErrorInformation().getMessage());
                }
                rows.add(row);
                ++n2;
            }
            Tables.showTable((PrintStream)System.out, Arrays.asList("ID", "State", "Error"), rows, (int)2);
        } else {
            System.out.println(String.format("Factory '%s' does not exists", factoryId));
        }
    }

    @Descriptor(value="Show configuration")
    public void show(@Descriptor(value="The factory id") String factoryId, @Descriptor(value="The configuration id") String configurationId) {
        Configuration cfg = this.admin.getConfiguration(factoryId, configurationId);
        if (cfg == null) {
            System.out.println(String.format("Configuration %s/%s does not exists", factoryId, configurationId));
        } else {
            System.out.println(String.format("%s - %s - %s", cfg.getFactoryId(), cfg.getId(), cfg.getState()));
            for (Map.Entry entry : cfg.getData().entrySet()) {
                System.out.println(String.format("\t'%s' => '%s'", entry.getKey(), entry.getValue()));
            }
            if (cfg.getErrorInformation() != null) {
                cfg.getErrorInformation().printStackTrace(System.out);
            }
        }
    }

    private Map<String, String> parse(String[] data) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            String[] toks = word.split("=", 2);
            if (toks.length == 1) {
                result.put(toks[0], null);
            } else if (toks.length == 2) {
                result.put(toks[0], toks[1]);
            }
            ++n2;
        }
        return result;
    }

    private static class CommonResultPrinter
    extends ResultPrinter {
        private final String operationName;

        public CommonResultPrinter(PrintStream out, String operationName) {
            super(out);
            this.operationName = operationName;
        }

        @Override
        protected void processFail(Exception e) {
            this.out.println("Failed - " + this.operationName + ":");
            e.printStackTrace(this.out);
        }

        @Override
        protected void processSuccess(Configuration configuration) {
            this.out.println("Completed - " + this.operationName + ":");
            this.out.println(configuration);
        }
    }

    private static abstract class ResultPrinter
    implements FutureListener<Configuration> {
        protected final PrintStream out;

        public ResultPrinter(PrintStream out) {
            this.out = out;
        }

        public void complete(Future<Configuration> future) {
            try {
                this.processSuccess(future.get());
            }
            catch (Exception e) {
                this.processFail(e);
            }
        }

        protected abstract void processFail(Exception var1);

        protected abstract void processSuccess(Configuration var1);
    }
}

