/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.scada.utils.str.StringHelper;

public class ConfigurationDataHelper {
    private final Map<String, String> data;

    public ConfigurationDataHelper(Map<String, String> parameters) {
        this.data = parameters;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public Integer getInteger(String name) {
        String str = this.data.get(name);
        if (str == null) {
            return null;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public int getInteger(String name, int defaultValue) {
        Integer result = this.getInteger(name);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public int getIntegerChecked(String name, String errorMessage) throws IllegalArgumentException, NumberFormatException {
        String str = this.data.get(name);
        if (str == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        return Integer.parseInt(str);
    }

    public Long getLong(String name) {
        String str = this.data.get(name);
        if (str == null) {
            return null;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public long getLong(String name, long defaultValue) {
        Long result = this.getLong(name);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public long getLongChecked(String name, String errorMessage) throws IllegalArgumentException, NumberFormatException {
        String str = this.data.get(name);
        if (str == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        return Long.parseLong(str);
    }

    public String getStringNonEmpty(String name) {
        String result = this.data.get(name);
        if (result == null) {
            return null;
        }
        if ("".equals(result)) {
            return null;
        }
        return result;
    }

    public String getString(String name) {
        return this.data.get(name);
    }

    public String getString(String name, String defaultValue) {
        String str = this.data.get(name);
        if (str != null) {
            return str;
        }
        return defaultValue;
    }

    public String getStringChecked(String name, String errorMessage) throws IllegalArgumentException {
        String str = this.data.get(name);
        if (str == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        return str;
    }

    public String getStringOfChecked(String name, Collection<String> whitelisted) throws IllegalArgumentException {
        String str = this.data.get(name);
        if (str == null) {
            throw new IllegalArgumentException(String.format("'%s' was null, but must be on of %s", name, whitelisted));
        }
        if (whitelisted.contains(str)) {
            return str;
        }
        throw new IllegalArgumentException(String.format("'%s' is not part of the allowed parameters (%s)", str, whitelisted));
    }

    public String getStringOfChecked(String name, String defaultValue, Collection<String> whitelisted) throws IllegalArgumentException {
        if (!whitelisted.contains(defaultValue)) {
            throw new IllegalArgumentException(String.format("the defaultValue '%s' is not part of the allowed parameters (%s)", defaultValue, whitelisted));
        }
        String str = this.data.get(name);
        if (str == null) {
            str = defaultValue;
        }
        if (whitelisted.contains(str)) {
            return str;
        }
        throw new IllegalArgumentException(String.format("'%s' is not part of the allowed parameters (%s)", str, whitelisted));
    }

    public Double getDouble(String name) {
        String str = this.data.get(name);
        if (str == null) {
            return null;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public double getDouble(String name, double defaultValue) {
        Double result = this.getDouble(name);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public double getDoubleChecked(String name, String errorMessage) throws IllegalArgumentException, NumberFormatException {
        String str = this.data.get(name);
        if (str == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        return Double.parseDouble(str);
    }

    public boolean getBooleanChecked(String name, String errorMessage) {
        String str = this.data.get(name);
        if (str == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        return Boolean.parseBoolean(str);
    }

    public Boolean getBoolean(String name) {
        String str = this.data.get(name);
        if (str == null) {
            return null;
        }
        try {
            return Boolean.parseBoolean(str);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        Boolean result = this.getBoolean(name);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public Map<String, String> getPrefixed(String prefix) {
        if (prefix == null) {
            return Collections.emptyMap();
        }
        int prefixLen = prefix.length();
        HashMap<String, String> result = new HashMap<String, String>(8);
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            String key = entry.getKey();
            if (key == null || !key.startsWith(prefix)) continue;
            String subKey = key.substring(prefixLen);
            result.put(subKey, entry.getValue());
        }
        return result;
    }

    public Properties getPrefixedProperties(String prefix) {
        Properties p = new Properties();
        p.putAll(this.getPrefixed(prefix));
        return p;
    }

    public <E extends Enum<E>> E getEnumChecked(String name, Class<E> enumType, String errorMessage) {
        return ConfigurationDataHelper.makeEnum(enumType, null, this.getStringChecked(name, errorMessage), false);
    }

    public <E extends Enum<E>> E getEnum(String name, Class<E> enumType) {
        return ConfigurationDataHelper.makeEnum(enumType, null, this.getString(name), false);
    }

    public <E extends Enum<E>> E getEnum(String name, Class<E> enumType, E defaultValue) {
        return ConfigurationDataHelper.makeEnum(enumType, defaultValue, this.getString(name), false);
    }

    public static <E extends Enum<E>> E makeEnum(Class<E> enumType, E defaultValue, String stringValue, boolean ignoreMissing) {
        if (stringValue == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(enumType, stringValue);
        }
        catch (IllegalArgumentException e) {
            if (ignoreMissing) {
                return defaultValue;
            }
            throw new IllegalArgumentException(ConfigurationDataHelper.makeEnumError(enumType, stringValue), e);
        }
    }

    protected static <E extends Enum<E>> String makeEnumError(Class<E> enumType, String stringValue) {
        return String.format("Value '%s' is not contained in enum. (Possible values: %s)", stringValue, StringHelper.join((Object[])enumType.getEnumConstants(), (String)", "));
    }
}

