/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.movingaverage;

import java.util.Date;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.DataItemValue;

public class DataItemValueLight
implements Comparable<DataItemValueLight> {
    public static final DataItemValueLight DISCONNECTED = new DataItemValueLight(Variant.NULL, SubscriptionState.DISCONNECTED, Long.MIN_VALUE, false, false);
    private final Variant value;
    private final SubscriptionState subscriptionState;
    private final long timestamp;
    private final boolean isManual;
    private final boolean isError;

    public DataItemValueLight(Variant value, SubscriptionState subscriptionState, long timestamp, boolean isManual, boolean isError) {
        if (subscriptionState == null) {
            throw new IllegalArgumentException("'subscriptionState' must not be null");
        }
        this.value = Variant.valueOf((Object)value);
        this.subscriptionState = subscriptionState;
        this.timestamp = timestamp;
        this.isManual = isManual;
        this.isError = isError;
    }

    public static DataItemValueLight valueOf(DataItemValue dataItemValue) {
        if (dataItemValue == null || dataItemValue.equals((Object)DataItemValue.DISCONNECTED)) {
            return DISCONNECTED;
        }
        return new DataItemValueLight(dataItemValue.getValue(), dataItemValue.getSubscriptionState(), dataItemValue.getTimestamp() == null ? Long.MIN_VALUE : dataItemValue.getTimestamp().getTimeInMillis(), dataItemValue.isManual(), dataItemValue.isError());
    }

    public static DataItemValueLight valueOf(DataItemValueLight dataItemValueLight) {
        if (dataItemValueLight == null || dataItemValueLight.equals(DISCONNECTED)) {
            return DISCONNECTED;
        }
        return new DataItemValueLight(dataItemValueLight.value, dataItemValueLight.subscriptionState, dataItemValueLight.timestamp, dataItemValueLight.isManual, dataItemValueLight.isError);
    }

    public Variant getValue() {
        return this.value;
    }

    public SubscriptionState getSubscriptionState() {
        return this.subscriptionState;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean hasValue() {
        return this.value.isNumber();
    }

    public boolean isManual() {
        return this.isManual;
    }

    public boolean isError() {
        return this.isError;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.subscriptionState == null ? 0 : this.subscriptionState.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataItemValueLight other = (DataItemValueLight)obj;
        if (this.subscriptionState != other.subscriptionState) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    @Override
    public int compareTo(DataItemValueLight o) {
        int c = 0;
        c = this.value.compareTo(o.value);
        if (c != 0) {
            return c;
        }
        c = this.subscriptionState.compareTo((Enum)o.subscriptionState);
        if (c != 0) {
            return c;
        }
        return Long.valueOf(this.timestamp).compareTo(o.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.value);
        sb.append("[");
        sb.append(this.subscriptionState);
        sb.append("]");
        sb.append(String.format("[%1$tF %1$tT,%1$tL]", new Date(this.timestamp)));
        return sb.toString();
    }
}

