/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.arduino;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.server.arduino.factory.ConfigurationFactoryImpl;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private ObjectPoolImpl<DataItem> itemPool;
    private ServiceRegistration<?> itemPoolHandle;
    private ExecutorService executor;
    private ConfigurationFactoryImpl service;
    private ServiceRegistration<ConfigurationFactory> factoryHandle;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.itemPool = new ObjectPoolImpl();
        this.itemPoolHandle = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.itemPool, DataItem.class);
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(context.getBundle().getSymbolicName()));
        this.service = new ConfigurationFactoryImpl(context, this.itemPool, this.executor);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("factoryId", "org.eclipse.scada.da.server.arduino.device");
        ((Dictionary)properties).put("service.description", "Arduino OpenSCADA Device");
        this.factoryHandle = context.registerService(ConfigurationFactory.class, (Object)this.service, properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.factoryHandle.unregister();
        this.itemPoolHandle.unregister();
        this.itemPool.dispose();
        this.service.dispose();
        this.executor.shutdown();
        this.executor = null;
        context = null;
    }
}

