/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.browser.common.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.scada.da.server.browser.common.query.ItemDescriptor;
import org.eclipse.scada.da.server.browser.common.query.ItemStorage;
import org.eclipse.scada.da.server.browser.common.query.SubscribeableStorage;

public class InvisibleStorage
implements SubscribeableStorage {
    private final Set<ItemDescriptor> items = new HashSet<ItemDescriptor>();
    private final Collection<ItemStorage> childs = new LinkedList<ItemStorage>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void added(ItemDescriptor descriptor) {
        InvisibleStorage invisibleStorage = this;
        synchronized (invisibleStorage) {
            if (this.items.contains(descriptor)) {
                return;
            }
            this.items.add(descriptor);
            this.notifyAdd(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removed(ItemDescriptor descriptor) {
        InvisibleStorage invisibleStorage = this;
        synchronized (invisibleStorage) {
            if (!this.items.remove(descriptor)) {
                return;
            }
            this.notifyRemove(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(ItemStorage child) {
        InvisibleStorage invisibleStorage = this;
        synchronized (invisibleStorage) {
            this.childs.add(child);
            for (ItemDescriptor desc : this.items) {
                child.added(desc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(ItemStorage child) {
        InvisibleStorage invisibleStorage = this;
        synchronized (invisibleStorage) {
            this.childs.remove(child);
        }
    }

    private void notifyAdd(ItemDescriptor desc) {
        for (ItemStorage child : this.childs) {
            child.added(desc);
        }
    }

    private void notifyRemove(ItemDescriptor desc) {
        for (ItemStorage child : this.childs) {
            child.removed(desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        InvisibleStorage invisibleStorage = this;
        synchronized (invisibleStorage) {
            for (ItemDescriptor desc : this.items) {
                this.notifyRemove(desc);
            }
            this.items.clear();
        }
    }
}

