/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.chain.item;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.chain.BaseChainItemCommon;
import org.eclipse.scada.utils.str.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SummarizeChainItem
extends BaseChainItemCommon {
    private static final Logger logger = LoggerFactory.getLogger(SummarizeChainItem.class);
    private final String sumStateName;
    private final String sumCountName;
    private final String sumListName;

    public SummarizeChainItem(String baseName) {
        this.sumStateName = baseName;
        this.sumCountName = String.valueOf(baseName) + ".count";
        this.sumListName = String.valueOf(baseName) + ".items";
        this.setReservedAttributes(this.sumStateName, this.sumCountName, this.sumListName);
    }

    protected abstract boolean matches(Variant var1, String var2, Variant var3);

    @Override
    public Variant process(Variant value, Map<String, Variant> attributes) {
        attributes.put(this.sumStateName, null);
        attributes.put(this.sumCountName, null);
        attributes.put(this.sumListName, null);
        long count = 0L;
        LinkedList<String> items = new LinkedList<String>();
        Set<String> ignoreItems = this.getIgnoreItems();
        for (Map.Entry<String, Variant> entry : attributes.entrySet()) {
            String attributeName = entry.getKey();
            if (attributeName.equals(this.sumStateName) || attributeName.equals(this.sumCountName) || attributeName.equals(this.sumListName) || ignoreItems.contains(attributeName)) continue;
            try {
                if (!this.matches(value, attributeName, entry.getValue()) || entry.getValue() == null || !entry.getValue().asBoolean()) continue;
                ++count;
                items.add(entry.getKey());
            }
            catch (Exception e) {
                logger.warn(String.format("Failed to summarize item '%s'", attributeName), (Throwable)e);
            }
        }
        attributes.put(this.sumStateName, Variant.valueOf((count > 0L ? 1 : 0) != 0));
        attributes.put(this.sumCountName, Variant.valueOf((long)count));
        attributes.put(this.sumListName, Variant.valueOf((Object)StringHelper.join(items, (String)", ")));
        return null;
    }

    protected Set<String> getIgnoreItems() {
        return Collections.emptySet();
    }
}

