/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.item.factory;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.chain.WriteHandler;
import org.eclipse.scada.da.server.common.chain.WriteHandlerItem;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.common.item.factory.CommonItemFactory;
import org.eclipse.scada.da.server.common.item.factory.HiveItemFactory;

public class FolderItemFactory
extends HiveItemFactory {
    private final String folderName;
    protected FolderCommon folder;
    private final FolderCommon parentFolder;

    public FolderItemFactory(HiveCommon hive, FolderCommon parentFolder, String baseId, String folderName) {
        this(null, hive, parentFolder, baseId, folderName, null);
    }

    public FolderItemFactory(CommonItemFactory parentFactory, HiveCommon hive, FolderCommon parentFolder, String baseId, String folderName) {
        this(parentFactory, hive, parentFolder, baseId, folderName, null);
    }

    public FolderItemFactory(CommonItemFactory parentFactory, HiveCommon hive, FolderCommon parentFolder, String baseId, String folderName, String idDelimiter) {
        super(parentFactory, hive, baseId, idDelimiter);
        this.parentFolder = parentFolder;
        this.folderName = folderName;
        if (this.parentFolder != null && this.folderName != null) {
            this.folder = new FolderCommon();
            parentFolder.add(this.folderName, this.folder, new HashMap<String, Variant>());
        }
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.parentFolder != null && this.folder != null && this.folderName != null) {
            this.parentFolder.remove(this.folderName);
        }
        super.dispose();
    }

    @Override
    public void disposeItem(DataItem item) {
        super.disposeItem(item);
        if (this.folder != null) {
            this.folder.remove(item);
        }
    }

    @Override
    protected DataItemCommand constructCommand(String localId) {
        DataItemCommand item = super.constructCommand(localId);
        this.addToFolder(item, localId, new HashMap<String, Variant>());
        return item;
    }

    @Override
    protected DataItemInputChained constructInput(String localId) {
        DataItemInputChained item = super.constructInput(localId);
        this.addToFolder(item, localId, new HashMap<String, Variant>());
        return item;
    }

    @Override
    protected WriteHandlerItem constructWriteHandler(String localId, WriteHandler writeHandler) {
        WriteHandlerItem item = super.constructWriteHandler(localId, writeHandler);
        this.addToFolder(item, localId, new HashMap<String, Variant>());
        return item;
    }

    @Override
    protected WriteHandlerItem constructInputOutput(String localId, WriteHandler writeHandler) {
        WriteHandlerItem item = super.constructInputOutput(localId, writeHandler);
        this.addToFolder(item, localId, new HashMap<String, Variant>());
        return item;
    }

    protected void addToFolder(DataItem item, String name, Map<String, Variant> attributes) {
        if (this.folder == null) {
            return;
        }
        this.folder.add(name, item.getInformation(), attributes);
    }

    public FolderCommon getFolder() {
        return this.folder;
    }

    public FolderItemFactory createSubFolderFactory(String name) {
        FolderItemFactory factory = new FolderItemFactory(this, this.hive, this.folder, name, name);
        this.addSubFactory(factory);
        return factory;
    }

    @Override
    public void disposeAllItems() {
        this.folder.clear();
        super.disposeAllItems();
    }
}

