/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.common;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ca.ConfigurationAdministratorListener;
import org.eclipse.scada.ca.ConfigurationEvent;
import org.eclipse.scada.ca.FactoryEvent;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerTracker {
    private static final Logger logger = LoggerFactory.getLogger(ListenerTracker.class);
    private final ServiceTracker<ConfigurationAdministratorListener, ConfigurationAdministratorListener> listenerTracker;
    private final ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("org.eclipse.scada.ca.common.ListenerTracker"));

    public ListenerTracker(BundleContext context) {
        this.listenerTracker = new ServiceTracker(context, ConfigurationAdministratorListener.class, null);
    }

    public void open() {
        this.listenerTracker.open();
    }

    public void close() {
        this.listenerTracker.close();
    }

    public void dispose() {
        this.executor.shutdown();
    }

    public void fireEvent(final ConfigurationEvent configurationEvent) {
        logger.debug("Fire configuration event: {}", (Object)configurationEvent);
        final Object[] services = this.listenerTracker.getServices();
        if (services != null && services.length > 0) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (services != null) {
                        Object[] objectArray = services;
                        int n = services.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            if (o instanceof ConfigurationAdministratorListener) {
                                ConfigurationAdministratorListener listener = (ConfigurationAdministratorListener)o;
                                try {
                                    listener.configurationEvent(configurationEvent);
                                }
                                catch (Throwable e) {
                                    logger.warn("Failed to handle listener", e);
                                }
                            }
                            ++n2;
                        }
                    }
                }
            });
        }
    }

    public void fireEvent(final FactoryEvent factoryEvent) {
        logger.debug("Fire factory event: {}", (Object)factoryEvent);
        final Object[] services = this.listenerTracker.getServices();
        if (services != null && services.length > 0) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (services != null) {
                        Object[] objectArray = services;
                        int n = services.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            if (o instanceof ConfigurationAdministratorListener) {
                                ConfigurationAdministratorListener listener = (ConfigurationAdministratorListener)o;
                                try {
                                    listener.factoryEvent(factoryEvent);
                                }
                                catch (Throwable e) {
                                    logger.warn("Failed to handle listener", e);
                                }
                            }
                            ++n2;
                        }
                    }
                }
            });
        }
    }
}

