/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.script;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.eclipse.scada.utils.osgi.pool.SingleObjectPoolServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterController {
    private static final Logger logger = LoggerFactory.getLogger(WriterController.class);
    private final ObjectPoolTracker<DataSource> tracker;
    private volatile Map<String, SingleObjectPoolServiceTracker<DataSource>> trackers = Collections.emptyMap();

    public WriterController(ObjectPoolTracker<DataSource> tracker) {
        this.tracker = tracker;
    }

    public void setWriteItems(Map<String, String> datasources) {
        HashMap<String, SingleObjectPoolServiceTracker<DataSource>> newTrackers = new HashMap<String, SingleObjectPoolServiceTracker<DataSource>>(1);
        for (Map.Entry<String, String> entry : datasources.entrySet()) {
            String name = entry.getKey();
            String dataSourceId = entry.getValue();
            SingleObjectPoolServiceTracker objectTracker = new SingleObjectPoolServiceTracker(this.tracker, dataSourceId, null);
            objectTracker.open();
            newTrackers.put(name, (SingleObjectPoolServiceTracker<DataSource>)objectTracker);
            logger.debug("Added {} as {}", (Object)dataSourceId, (Object)name);
        }
        Map<String, SingleObjectPoolServiceTracker<DataSource>> oldTrackers = this.trackers;
        this.trackers = newTrackers;
        for (SingleObjectPoolServiceTracker<DataSource> tracker : oldTrackers.values()) {
            tracker.close();
        }
    }

    public void write(String dataSourceName, Object value) throws Exception {
        logger.debug("Write request - name: {}, value: {}", (Object)dataSourceName, value);
        SingleObjectPoolServiceTracker<DataSource> objectTracker = this.trackers.get(dataSourceName);
        if (objectTracker == null) {
            throw new IllegalArgumentException(String.format("Data source '%s' is not configured", dataSourceName));
        }
        DataSource o = (DataSource)objectTracker.getCurrentService();
        if (o == null) {
            throw new IllegalStateException(String.format("Data source '%s' was not found", dataSourceName));
        }
        o.startWriteValue(Variant.valueOf((Object)value), null);
    }

    public void writeAsText(String itemId, String value) throws Exception {
        this.write(itemId, VariantEditor.toVariant((String)value));
    }
}

