/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master.common.manual;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.master.common.AbstractCommonHandlerImpl;
import org.eclipse.scada.da.master.common.internal.Activator;
import org.eclipse.scada.da.master.common.manual.Messages;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManualHandlerImpl
extends AbstractCommonHandlerImpl {
    private static final Logger logger = LoggerFactory.getLogger(ManualHandlerImpl.class);
    private final EventProcessor eventProcessor;
    private final String id;
    private final boolean sendAllUpdates = Boolean.getBoolean("org.eclipse.scada.da.master.common.manual.sendAllUpdates");
    private ManualStateData state = new ManualStateData(Variant.NULL, null, null, null);
    private final String attrActive;
    private final String attrUser;
    private final String attrReason;
    private final String attrValueOriginal;
    private final String attrErrorOriginal;
    private final String attrErrorCountOriginal;
    private final String attrErrorItemsOriginal;
    private final String attrTimestampOriginal;
    private final String attrValue;

    public ManualHandlerImpl(String configurationId, EventProcessor eventProcessor, ObjectPoolTracker<MasterItem> poolTracker, int priority, ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> caTracker) {
        super(configurationId, poolTracker, priority, caTracker, "org.eclipse.scada.da.manual", "org.eclipse.scada.da.manual");
        this.id = configurationId;
        this.eventProcessor = eventProcessor;
        this.attrActive = this.getPrefixed("active", Activator.getStringInterner());
        this.attrUser = this.getPrefixed("user", Activator.getStringInterner());
        this.attrReason = this.getPrefixed("reason", Activator.getStringInterner());
        this.attrValue = this.getPrefixed("value", Activator.getStringInterner());
        this.attrValueOriginal = this.getPrefixed("value.original", Activator.getStringInterner());
        this.attrErrorOriginal = this.getPrefixed("error.original", Activator.getStringInterner());
        this.attrTimestampOriginal = this.getPrefixed("timestamp.original", Activator.getStringInterner());
        this.attrErrorCountOriginal = this.getPrefixed("error.count.original", Activator.getStringInterner());
        this.attrErrorItemsOriginal = this.getPrefixed("error.items.original", Activator.getStringInterner());
    }

    @Override
    protected void processDataUpdate(Map<String, Object> context, DataItemValue.Builder builder) throws Exception {
        Variant originalErrorItems;
        Variant originalValue = builder.getValue();
        this.injectAttributes(builder);
        ManualStateData state = this.state;
        if (state.getValue().isNull()) {
            Date currentTimestamp = this.makeTimestamp(builder);
            if (currentTimestamp != null && state.getTimestmap() != null && currentTimestamp.after(state.getTimestmap())) {
                state.setTimestmap(null);
            }
            if (state.getTimestmap() != null && (currentTimestamp == null || state.getTimestmap().after(currentTimestamp))) {
                this.injectTimestamp(builder, state);
            }
            return;
        }
        Variant originalError = (Variant)builder.getAttributes().remove("error");
        builder.setAttribute(this.attrErrorOriginal, originalError);
        builder.setAttribute("error", Variant.FALSE);
        builder.setSubscriptionState(SubscriptionState.CONNECTED);
        builder.setSubscriptionError(null);
        Variant originalErrorCount = (Variant)builder.getAttributes().remove("error.count");
        if (originalErrorCount != null) {
            builder.setAttribute("error.count", Variant.valueOf((int)0));
            builder.setAttribute(this.attrErrorCountOriginal, originalErrorCount);
        }
        if ((originalErrorItems = (Variant)builder.getAttributes().remove("error.items")) != null) {
            builder.setAttribute("error.items", Variant.valueOf((Object)""));
            builder.setAttribute(this.attrErrorItemsOriginal, originalErrorItems);
        }
        builder.setAttribute(this.attrValueOriginal, originalValue);
        builder.setAttribute(this.attrActive, Variant.TRUE);
        builder.setAttribute(this.getPrefixed(null, null), Variant.TRUE);
        builder.setValue(this.state.getValue());
        if (state.getUser() != null) {
            builder.setAttribute(this.attrUser, Variant.valueOf((Object)state.getUser()));
        }
        if (state.getReason() != null) {
            builder.setAttribute(this.attrReason, Variant.valueOf((Object)state.getReason()));
        }
        this.injectTimestamp(builder, state);
    }

    private Date makeTimestamp(DataItemValue.Builder value) {
        if (value == null) {
            return null;
        }
        Calendar c = value.getTimestamp();
        if (c == null) {
            return null;
        }
        return c.getTime();
    }

    private void injectTimestamp(DataItemValue.Builder builder, ManualStateData state) {
        if (state.getTimestmap() != null) {
            Variant originalTimestamp = (Variant)builder.getAttributes().get("timestamp");
            builder.setAttribute("timestamp", Variant.valueOf((long)state.getTimestmap().getTime()));
            if (originalTimestamp != null) {
                builder.setAttribute(this.attrTimestampOriginal, originalTimestamp);
            }
        }
    }

    public synchronized void update(UserInformation userInformation, Map<String, String> parameters) throws Exception {
        Variant newValue;
        super.update(userInformation, parameters);
        VariantEditor ve = new VariantEditor();
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        String str = cfg.getString("value");
        logger.debug("Request to set manual value '{}'", (Object)str);
        if (str != null) {
            ve.setAsText(str);
            newValue = Variant.valueOf((Object)ve.getValue());
        } else {
            newValue = Variant.NULL;
        }
        String newUser = cfg.getString("user");
        String newReason = cfg.getString("reason");
        Date ts = new Date();
        Date newTimestamp = this.makeNewTimestamp(cfg, ts, newValue);
        ManualStateData newState = new ManualStateData(newValue, newUser, newReason, newTimestamp);
        if (!this.state.equals(newState) || this.sendAllUpdates) {
            this.sendUpdateEvent(newState, ts);
        }
        this.state = newState;
        this.reprocess();
    }

    private Date makeNewTimestamp(ConfigurationDataHelper cfg, Date ts, Variant newValue) {
        Long newTimestamp = cfg.getLong("timestamp");
        if (newTimestamp != null) {
            return new Date(newTimestamp);
        }
        if (this.state.getValue().equals((Object)newValue)) {
            return this.state.getTimestmap();
        }
        return ts;
    }

    private void sendUpdateEvent(ManualStateData newState, Date eventTimestamp) {
        Event.EventBuilder builder = this.createEventBuilder();
        builder.entryTimestamp(eventTimestamp);
        builder.sourceTimestamp(eventTimestamp);
        builder.attribute(Event.Fields.MONITOR_TYPE, (Object)"MAN");
        builder.attribute(Event.Fields.SOURCE, (Object)this.id);
        builder.attribute(Event.Fields.VALUE, newState.getValue());
        if (newState.getValue().isNull()) {
            builder.attribute(Event.Fields.MESSAGE, (Object)Messages.getString("ManualHandlerImpl.Reset.Message"));
            builder.attribute(Event.Fields.MESSAGE_CODE, (Object)"MAN-RESET");
            builder.attribute(Event.Fields.EVENT_TYPE, (Object)Messages.getString("ManualHandlerImpl.Reset.Type"));
        } else {
            builder.attribute(Event.Fields.MESSAGE, (Object)Messages.getString("ManualHandlerImpl.Set.Message"));
            builder.attribute(Event.Fields.MESSAGE_CODE, (Object)"MAN-SET");
            builder.attribute(Event.Fields.EVENT_TYPE, (Object)Messages.getString("ManualHandlerImpl.Set.Type"));
        }
        if (newState.getUser() != null && !newState.getUser().isEmpty()) {
            builder.attribute(Event.Fields.ACTOR_NAME, (Object)newState.getUser());
            builder.attribute(Event.Fields.ACTOR_TYPE, (Object)"USER");
        }
        if (newState.getReason() != null && !newState.getReason().isEmpty()) {
            builder.attribute(Event.Fields.COMMENT, (Object)newState.getReason());
        }
        this.eventProcessor.publishEvent(builder.build());
    }

    protected void injectAttributes(DataItemValue.Builder builder) {
        builder.setAttribute(this.getPrefixed(null, null), this.state.getValue().isNull() ? Variant.FALSE : Variant.TRUE);
        builder.setAttribute(this.attrActive, this.state.getValue().isNull() ? Variant.FALSE : Variant.TRUE);
        builder.setAttribute(this.attrValue, this.state.getValue());
        builder.setAttribute(this.attrReason, Variant.valueOf((Object)this.state.getReason()));
        builder.setAttribute(this.attrUser, Variant.valueOf((Object)this.state.getUser()));
    }

    protected WriteAttributeResults handleUpdate(Map<String, Variant> attributes, OperationParameters operationParameters) throws Exception {
        Variant timestamp;
        Variant reason;
        HashMap<String, String> data = new HashMap<String, String>();
        Variant value = attributes.get("value");
        if (value != null) {
            data.put("value", value.toString());
        }
        if (operationParameters != null && operationParameters.getUserInformation() != null && operationParameters.getUserInformation().getName() != null) {
            data.put("user", operationParameters.getUserInformation().getName());
        } else {
            data.put("user", "");
        }
        if (value != null) {
            data.put("reason", "");
        }
        if ((reason = attributes.get("reason")) != null && !reason.isNull()) {
            data.put("reason", reason.toString());
        }
        if ((timestamp = attributes.get("timestamp")) != null && !timestamp.isNull()) {
            data.put("timestamp", "" + timestamp.asLong(Long.valueOf(System.currentTimeMillis())));
        } else {
            data.put("timestamp", "" + System.currentTimeMillis());
        }
        return this.updateConfiguration(data, attributes, false, operationParameters);
    }

    public static class ManualStateData {
        private Variant value;
        private String user;
        private String reason;
        private Date timestmap;

        public ManualStateData(Variant value, String user, String reason, Date timestmap) {
            this.value = value != null ? value : Variant.NULL;
            this.user = user;
            this.reason = reason;
            this.timestmap = timestmap;
        }

        public Variant getValue() {
            return this.value;
        }

        public void setValue(Variant value) {
            this.value = value;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getReason() {
            return this.reason;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public Date getTimestmap() {
            return this.timestmap;
        }

        public void setTimestmap(Date timestmap) {
            this.timestmap = timestmap;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
            result = 31 * result + (this.timestmap == null ? 0 : this.timestmap.hashCode());
            result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ManualStateData other = (ManualStateData)obj;
            if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
                return false;
            }
            if (this.timestmap == null ? other.timestmap != null : !this.timestmap.equals(other.timestmap)) {
                return false;
            }
            if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
        }
    }
}

