/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exec.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class ProcessConfiguration {
    private String exec = "";
    private String[] arguments = new String[0];
    private Map<String, String> environment;

    public ProcessConfiguration(String exec, String[] arguments, Map<String, String> environment) {
        this.exec = exec;
        this.arguments = arguments;
        this.environment = environment;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public String getExec() {
        return this.exec;
    }

    public void setExec(String exec) {
        this.exec = exec;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public ProcessBuilder asProcessBuilder() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.exec);
        args.addAll(Arrays.asList(this.arguments));
        ProcessBuilder builder = new ProcessBuilder(args);
        if (this.environment != null) {
            Map<String, String> env = builder.environment();
            for (Map.Entry<String, String> entry : this.environment.entrySet()) {
                if (entry.getValue() == null) {
                    env.remove(entry.getKey());
                    continue;
                }
                env.put(entry.getKey(), entry.getValue());
            }
        }
        return builder;
    }
}

