/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exec.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.scada.da.server.exec.command.ExecutionResult;
import org.eclipse.scada.da.server.exec.command.ProcessListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(CommandExecutor.class);

    public static ExecutionResult executeCommand(ProcessBuilder processBuilder, ProcessListener listener) {
        ExecutionResult result = new ExecutionResult();
        Process p = null;
        try {
            try {
                long start = System.currentTimeMillis();
                p = processBuilder.start();
                if (listener != null) {
                    listener.processCreated(p);
                }
                CommandExecutor.closeStream(p.getOutputStream());
                p.waitFor();
                long end = System.currentTimeMillis();
                result.setRuntime(end - start);
                int exitValue = p.exitValue();
                result.setExitValue(exitValue);
                InputStream input = p.getInputStream();
                result.setOutput(CommandExecutor.inputStreamToString(input));
                InputStream error = p.getErrorStream();
                result.setErrorOutput(CommandExecutor.inputStreamToString(error));
            }
            catch (Throwable e) {
                result.setExecutionError(e);
                ExecutionResult executionResult = result;
                if (listener != null) {
                    listener.processCompleted();
                }
                if (p != null) {
                    CommandExecutor.closeStream(p.getErrorStream());
                    CommandExecutor.closeStream(p.getInputStream());
                    CommandExecutor.closeStream(p.getOutputStream());
                }
                return executionResult;
            }
        }
        finally {
            if (listener != null) {
                listener.processCompleted();
            }
            if (p != null) {
                CommandExecutor.closeStream(p.getErrorStream());
                CommandExecutor.closeStream(p.getInputStream());
                CommandExecutor.closeStream(p.getOutputStream());
            }
        }
        return result;
    }

    protected static void closeStream(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close stream", (Throwable)e);
        }
    }

    private static String inputStreamToString(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader br = new BufferedReader(inputStreamReader);
        String output = "";
        String line = "";
        while ((line = br.readLine()) != null) {
            output = String.valueOf(output) + line;
        }
        return output;
    }
}

