/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server.ngp;

import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.eclipse.scada.core.server.ngp.ServerBase;
import org.eclipse.scada.core.server.ngp.ServerConnection;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfiguration;
import org.eclipse.scada.protocol.ngp.common.mc.message.CloseMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerBaseHandler
implements IoHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServerBaseHandler.class);
    private final ServerBase server;
    private final ProtocolConfiguration protocolConfiguration;

    public ServerBaseHandler(ServerBase server, ProtocolConfiguration protocolConfiguration) {
        this.server = server;
        this.protocolConfiguration = protocolConfiguration;
    }

    public void exceptionCaught(IoSession session, Throwable error) throws Exception {
        logger.warn(String.format("Session (%s) failed. Closing!", session), error);
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        logger.trace("Received message: {}", message);
        Object o = session.getAttribute((Object)"connection");
        if (o instanceof ServerConnection) {
            ((ServerConnection)o).handleMessageReceived(message);
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
    }

    public void sessionClosed(IoSession session) throws Exception {
        logger.info("Session closed");
        Object o = session.getAttribute((Object)"connection");
        if (o instanceof ServerConnection) {
            ((ServerConnection)o).dispose();
        }
    }

    public void sessionCreated(IoSession session) throws Exception {
        this.protocolConfiguration.assign(session);
    }

    public void sessionIdle(IoSession session, IdleStatus idleStatus) throws Exception {
    }

    public void sessionOpened(IoSession session) throws Exception {
        try {
            ServerConnection connection = this.server.createNewConnection(session);
            session.setAttribute((Object)"connection", (Object)connection);
        }
        catch (Exception e) {
            session.write((Object)new CloseMessage("Failed to create server side connection: " + e, -1));
            session.close(false);
        }
    }
}

