/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.storage.slave.hds;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.hd.server.storage.slave.hds.StorageManager;
import org.eclipse.scada.hds.DataFilePool;
import org.eclipse.scada.utils.concurrent.ScheduledExportedExecutorService;
import org.eclipse.scada.utils.str.StringReplacer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final String BASE_PATH_PROP = "org.eclipse.scada.hd.server.storage.slave.hds.basePath";
    private static BundleContext context;
    private ScheduledExecutorService executor;
    private final List<StorageManager> storageManagers = new LinkedList<StorageManager>();
    private DataFilePool pool;
    private ScheduledExportedExecutorService eventExecutor;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.executor = new ScheduledExportedExecutorService(BASE_PATH_PROP, 1);
        this.eventExecutor = new ScheduledExportedExecutorService("org.eclipse.scada.hd.server.storage.slave.hds.events", 1);
        this.pool = new DataFilePool(Integer.getInteger("org.eclipse.scada.hd.server.storage.slave.hds.instanceCountTarget", 10).intValue());
        String basePaths = System.getProperty(BASE_PATH_PROP);
        if (basePaths == null || basePaths.isEmpty()) {
            throw new IllegalStateException(String.format("Property '%s' must be set in order to activate bundle.", BASE_PATH_PROP));
        }
        try {
            String[] stringArray = basePaths.split(":");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if ((path = StringReplacer.replace((String)path, (Map)System.getProperties())).startsWith("@")) {
                    File dir = new File(path.substring(1));
                    if (!dir.isDirectory()) {
                        throw new IllegalStateException(String.format("'%s' is not a directory", dir));
                    }
                    File[] fileArray = dir.listFiles();
                    int n3 = fileArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File child = fileArray[n4];
                        this.storageManagers.add(new StorageManager(bundleContext, child, this.pool, this.executor, (ScheduledExecutorService)this.eventExecutor));
                        ++n4;
                    }
                } else {
                    this.storageManagers.add(new StorageManager(bundleContext, new File(path), this.pool, this.executor, (ScheduledExecutorService)this.eventExecutor));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            this.dispose();
            throw new Exception("Failed to start up bundle", e);
        }
    }

    private void dispose() {
        if (this.pool != null) {
            this.pool.dispose();
            this.pool = null;
        }
        for (StorageManager manager : this.storageManagers) {
            manager.dispose();
        }
        this.storageManagers.clear();
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        if (this.eventExecutor != null) {
            this.eventExecutor.shutdown();
            this.eventExecutor = null;
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.dispose();
        context = null;
    }
}

