/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scada.ca.Configuration;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.ca.Factory;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ListServlet
extends HttpServlet {
    private static final long serialVersionUID = -4627580623796526837L;
    private final ServiceTracker<ConfigurationAdministrator, ConfigurationAdministrator> adminTracker;

    public ListServlet(BundleContext context) {
        this.adminTracker = new ServiceTracker(context, ConfigurationAdministrator.class, null);
        this.adminTracker.open();
    }

    public void destroy() {
        this.adminTracker.close();
        super.destroy();
    }

    protected ConfigurationAdministrator getAdmin() {
        return (ConfigurationAdministrator)this.adminTracker.getService();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    private void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ConfigurationAdministrator admin = this.getAdmin();
        if (admin == null) {
            resp.sendError(503, "The configuration administrator could not be found");
            return;
        }
        this.startPage(resp, "List Factories");
        try {
            if (req.getParameter("cmd_create") != null) {
                this.handleCreate(admin, req, resp);
            }
            if (req.getParameter("cmd_purge") != null) {
                this.handlePurge(admin, req, resp);
            }
            if (req.getParameter("cmd_delete") != null) {
                this.handleDelete(admin, req, resp);
            }
            if (req.getParameter("cmd_update") != null) {
                this.handleUpdate(admin, req, resp);
            }
            this.showFactories(resp, admin);
        }
        finally {
            this.stopPage(resp);
        }
    }

    private void handlePurge(ConfigurationAdministrator admin, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String factoryId = req.getParameter("factoryId");
        if (factoryId == null) {
            return;
        }
        PrintWriter stream = resp.getWriter();
        this.waitForFuture(stream, admin.purgeFactory(null, factoryId));
    }

    private void handleUpdate(ConfigurationAdministrator admin, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String factoryId = req.getParameter("factoryId");
        String configurationId = req.getParameter("configurationId");
        String data = req.getParameter("data");
        if (factoryId == null || configurationId == null || data == null) {
            return;
        }
        PrintWriter stream = resp.getWriter();
        this.waitForFuture(stream, admin.updateConfiguration(null, factoryId, configurationId, this.parseData(data), true));
    }

    private void handleDelete(ConfigurationAdministrator admin, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String factoryId = req.getParameter("factoryId");
        String configurationId = req.getParameter("configurationId");
        PrintWriter stream = resp.getWriter();
        this.waitForFuture(stream, admin.deleteConfiguration(null, factoryId, configurationId));
    }

    private void handleCreate(ConfigurationAdministrator admin, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String id = req.getParameter("id");
        String data = req.getParameter("data");
        String factoryId = req.getParameter("factoryId");
        if (id == null || id.length() <= 0) {
            return;
        }
        PrintWriter stream = resp.getWriter();
        stream.print("<div class='log'>");
        stream.print(String.format("<div class='%s'>%s</div>", "info", "Creating configuration " + id + " => " + data));
        Map<String, String> properties = this.parseData(data);
        this.waitForFuture(stream, admin.createConfiguration(null, factoryId, id, properties));
        stream.print("</div>");
    }

    private void waitForFuture(PrintWriter stream, NotifyFuture<?> future) throws IOException {
        try {
            future.get(1L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            stream.print("Failed to wait");
            stream.print("<pre>");
            e.printStackTrace(stream);
            stream.print("</pre>");
        }
    }

    private Map<String, String> parseData(String data) throws IOException {
        if (data == null || data.length() <= 0) {
            return Collections.emptyMap();
        }
        Properties p = this.parseProperties(data);
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            properties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return properties;
    }

    private Properties parseProperties(String data) throws IOException {
        final StringReader r = new StringReader(data);
        Properties p = new Properties();
        p.load(new InputStream(){

            @Override
            public int read() throws IOException {
                return r.read();
            }
        });
        return p;
    }

    private void stopPage(HttpServletResponse resp) throws IOException {
        resp.getWriter().print("</body></html>");
    }

    private void startPage(HttpServletResponse resp, String title) throws IOException {
        resp.setCharacterEncoding("UTF-8");
        resp.setContentType("text/html; charset=UTF-8");
        PrintWriter stream = resp.getWriter();
        stream.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        stream.println("<html>");
        stream.println("<head>");
        stream.println("<title>" + title + "</title>");
        stream.println("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">");
        stream.println("<script src=\"/ca/resources/code.js\" type=\"text/javascript\"></script>");
        stream.println("<link type=\"text/css\" media=\"screen,print\" rel=\"stylesheet\" href=\"/ca/resources/style.css\"></link>");
        stream.println("</head><body>");
    }

    private void showFactories(HttpServletResponse resp, ConfigurationAdministrator admin) throws IOException {
        PrintWriter stream = resp.getWriter();
        stream.print("<table class='factories'>");
        stream.print("<tr><th>ID</th><th>Description</th><th>#</th><th>State</th></tr>");
        ArrayList<Factory> factories = new ArrayList<Factory>(Arrays.asList(admin.getKnownFactories()));
        Collections.sort(factories, new Comparator<Factory>(){

            @Override
            public int compare(Factory o1, Factory o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        for (Factory factory : factories) {
            stream.print("<tr>");
            stream.print(String.format("<td><a href=\"javascript:selectFactory('%1$s')\">%1$s</a></td>", factory.getId()));
            stream.print(String.format("<td>%s</td>", factory.getDescription()));
            Configuration[] configurations = admin.getConfigurations(factory.getId());
            stream.print(String.format("<td>%s</td>", configurations.length));
            stream.print(String.format("<td>%s</td>", factory.getState()));
            stream.print("</tr>");
            if (configurations.length <= 0) continue;
            stream.print("<tr><td></td><td colspan='4'>");
            this.showConfigurations(resp, admin, factory.getId(), configurations);
            stream.print("</td></tr>");
        }
        stream.print("</table>");
        stream.print("<form method='GET'><input type='submit' value='Refresh' /></form>");
        stream.print("<form method='POST'>");
        stream.print("<label for='create_factoryId'>Factory Id:</label><input id='create_factory_id' type='text' value='' name='factoryId' /><br />");
        stream.print("<label for='create_id'>Id:</label><input id='create_id' type='text' value='' name='id' /><br />");
        stream.print("<textarea name='data' cols='60' rows='5'></textarea><br />");
        stream.print("<input type='submit' value='Create' name='cmd_create' /><br />");
        stream.print("</form>");
    }

    private void showConfigurations(HttpServletResponse resp, ConfigurationAdministrator admin, String factoryId, Configuration[] configurations) throws IOException {
        PrintWriter stream = resp.getWriter();
        stream.print("<table class='configuration' width='100%'>");
        stream.print("<tr><th>ID</th><th>State</th><th>Error</th><th>Data</th></tr>");
        Arrays.sort(configurations, new Comparator<Configuration>(){

            @Override
            public int compare(Configuration o1, Configuration o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        Configuration[] configurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            Configuration cfg = configurationArray[n2];
            stream.print("<tr>");
            stream.print(String.format("<td>%s</td>", cfg.getId()));
            stream.print(String.format("<td>%s</td>", cfg.getState()));
            if (cfg.getErrorInformation() != null) {
                stream.print(String.format("<td>%s</td>", cfg.getErrorInformation().getMessage()));
            } else {
                stream.print(String.format("<td></td>", new Object[0]));
            }
            stream.print("<td><div style='float:right;'>");
            this.showData(stream, cfg.getData(), factoryId, cfg.getId());
            stream.print("<form method='post'><input type='Submit' value='Delete' name='cmd_delete' /><input type='hidden' name='factoryId' value='" + factoryId + "' /><input type='hidden' name='configurationId' value=" + cfg.getId() + " /></form>");
            stream.print("</div></td>");
            stream.print("</tr>");
            ++n2;
        }
        stream.print("</table>");
    }

    private void showData(PrintWriter stream, Map<String, String> data, String factoryId, String configurationId) throws IOException {
        Properties p = new Properties();
        if (data != null) {
            p.putAll(data);
        }
        final StringWriter sw = new StringWriter();
        p.store(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                sw.write(b);
            }
        }, null);
        stream.print("<form method='post'>");
        stream.print("<textarea name='data' rows='5' cols='60'>");
        stream.print(sw.getBuffer().toString());
        stream.print("</textarea><br/>");
        stream.print(String.format("<input type='hidden' name='factoryId' value='%s' />", factoryId));
        stream.print(String.format("<input type='hidden' name='configurationId' value='%s' />", configurationId));
        stream.print("<input type='submit' value='Update' name='cmd_update' /></form>");
    }
}

